package net.kronoz.odyssey.entity.apostasy;

import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.light.data.PointLightData;
import foundry.veil.api.client.render.light.renderer.LightRenderHandle;
import net.kronoz.odyssey.entity.projectile.LaserProjectileEntity;
import net.kronoz.odyssey.hud.death.DeathUICutscene;
import net.kronoz.odyssey.init.ModEntities;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5712;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animation.AnimatableManager;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class ApostasyEntity extends class_1314 implements software.bernie.geckolib.animatable.GeoEntity {
    // so much junk code it's insane
    public enum Phase {P1, P2, P3, P4}

    private static final double RING1_R = 2.4;
    private static final double RING2_R = 3.1;
    private static final double RING3_R = 3.8;
    private static final double RINGS_Y = 1.6;
    private static final int RING_SHOT_INTERVAL = 20;
    private static final int HUGE_LASER_INTERVAL = 65;
    private static final double HUGE_LASER_SPEED = 2.75;
    private static final double SMALL_LASER_SPEED = 2.15;

    private static final double EYE_ALIGN_DEG = 22.5;

    private int eyeBurstShotsLeft = 0;
    private int glowShotCooldown = 0;
    private int glowMuzzleIndex = 0;

    private static final int TELEGRAPH_TICKS = 20;
    private static final int P2_SINGLE_COOLDOWN = 60;
    private static final int P3_ZONE_COOLDOWN = 150;
    private static final int PHASE3_BURST = 20;
    private static final int PHASE3_MIN_R = 10, PHASE3_MAX_R = 50;
    private static final double KEEP_OUT_RADIUS = 20.0;
    private static final double KEEP_OUT_PUSH = 20.4;
    private static final double LINE_TRIGGER_RANGE = 20.0;

    private static final double HOVER_OFFSET = 8.0;
    private static final double HOVER_K = 0.35;
    private static final double HOVER_D = 0.50;
    private static final double HOVER_MAX_VY = 0.5;
    private static final double HOVER_SAMPLE_UP = 24.0;
    private static final double HOVER_SAMPLE_DOWN = 64.0;

    private int ringShotCooldown = 10;
    private int hugeLaserCooldown = 40;
    private int lightningCooldown = 40;

    private int shockwaveCooldown = 0;
    private static final int SHOCKWAVE_COOLDOWN_P1 = 120;
    private static final int SHOCKWAVE_COOLDOWN_P2 = 90;
    private static final int SHOCKWAVE_COOLDOWN_P3 = 70;

    private Phase phase = Phase.P1;
    private double hoverVy = 0.0;
    private double lastTargetY = Double.NaN;

    private static final class PendingStrike {
        final class_2338 pos;
        int ticks;

        PendingStrike(class_2338 pos, int ticks) {
            this.pos = pos;
            this.ticks = ticks;
        }
    }

    private final List<PendingStrike> pendingStrikes = new ArrayList<>();

    private final software.bernie.geckolib.animatable.instance.AnimatableInstanceCache cache =
            software.bernie.geckolib.util.GeckoLibUtil.createInstanceCache(this);

    public ApostasyEntity(class_1299<? extends class_1314> type, class_1937 world) {
        super(type, world);
        this.field_6194 = 50;
        this.field_5985 = true;
        this.method_5875(true);
        this.field_5960 = false;
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1314.method_26828()
                .method_26868(class_5134.field_23716, 900.0)
                .method_26868(class_5134.field_23719, 0.0)
                .method_26868(class_5134.field_23718, 1.0)
                .method_26868(class_5134.field_23717, 64.0);
    }

    private void updatePhase() {
        float pct = method_6032() / method_6063();
        Phase newPhase = pct > 0.75f ? Phase.P1 : pct > 0.50f ? Phase.P2 : pct > 0.25f ? Phase.P3 : Phase.P4;
        if (newPhase != phase) phase = newPhase;
    }

    @Override
    protected void method_5959() {
        this.field_6201.method_6277(0, new BrainGoal());
    }

    public void method_5982() {
        if (this.method_37908().method_8407() == class_1267.field_5801 && this.method_23734()) {
            this.method_31472();
        } else {
            this.field_6278 = 0;
        }
    }

    private class BrainGoal extends class_1352 {
        BrainGoal() {
            method_6265(EnumSet.of(class_4134.field_18405, class_4134.field_18406));
        }

        @Override
        public boolean method_6264() {
            return true;
        }

        @Override
        public void method_6268() {
            ApostasyEntity.this.tickBrain();
        }
    }

    private void tickBrain() {
        if (this.method_37908().field_9236) return;
        updatePhase();
        repulsePlayers();
        tickPendingStrikes();
        tickGlowHoming();
        class_1657 target = getClosestTarget();
        if (target == null) return;
        switch (phase) {
            case P1 -> handlePhase1(target);
            case P2 -> handlePhase2(target);
            case P3, P4 -> handlePhase3(target);
        }
        if (shockwaveCooldown > 0) shockwaveCooldown--;
    }

    private void repulsePlayers() {
        var box = this.method_5829().method_1014(KEEP_OUT_RADIUS);
        var players = this.method_37908().method_8390(class_1657.class, box, p -> p.method_5805() && !p.method_7325());
        for (class_1657 p : players) {
            class_243 d = p.method_19538().method_1020(this.method_19538());
            double dist = Math.max(0.2, d.method_1033());
            double t = Math.max(0.0, KEEP_OUT_RADIUS - dist) / KEEP_OUT_RADIUS;
            class_243 n = d.method_1021(1.0 / dist);
            double push = KEEP_OUT_PUSH * (0.6 + 0.4 * t);
            p.method_5762(n.field_1352 * push, 0.35, n.field_1350 * push);
            p.field_6007 = true;
            p.method_5844(p.method_37908().method_8320(p.method_24515()), new class_243(0.2, 1.0, 0.2));
        }
    }

    private @Nullable class_1657 getClosestTarget() {
        return this.method_37908().method_18460(this, 64.0);
    }

    private void handlePhase1(class_1657 target) {
        if (ringShotCooldown-- <= 0) {
            ringShotCooldown = RING_SHOT_INTERVAL;
            fireRingsBurst(target);
        }
        if (this.field_5974.method_43057() < 0.10f) tryStartEyeBurst(target, 6);
        if (this.field_5974.method_43057() < 0.04f) tryShockwave(target);
    }

    private void handlePhase2(class_1657 target) {
        if (hugeLaserCooldown-- <= 0) {
            hugeLaserCooldown = HUGE_LASER_INTERVAL;
            fireEyeHugeLaser(target);
        }
        if (this.field_5974.method_43057() < 0.14f) tryStartEyeBurst(target, 8);
        if (lightningCooldown-- <= 0) {
            lightningCooldown = P2_SINGLE_COOLDOWN;
            class_2338 strikePos = safeStrikeNear(target.method_24515());
            scheduleLightning(strikePos, TELEGRAPH_TICKS);
            if (this.method_37908() instanceof class_3218 sw) {
                java.util.List<class_2680> pulled = pullDownColumnBlocks(sw, strikePos, 8, 4);
                spawnDebrisCloud(sw, strikePos, pulled, 4);
            }
        }
        if (this.field_5974.method_43057() < 0.06f) tryShockwave(target);
        boolean near = this.method_5858(target) <= (LINE_TRIGGER_RANGE * LINE_TRIGGER_RANGE);
        if (near && this.field_5974.method_43057() < 0.05f) {
            scheduleLightningLineTowards(target, 8, 5);
        }
        if (this.field_5974.method_43057() < 0.03f && hugeLaserCooldown <= 0) {
            hugeLaserCooldown = 45;
            fireEyeHugeLaser(target);
        } else if (hugeLaserCooldown > 0) hugeLaserCooldown--;
    }

    private void handlePhase3(class_1657 target) {
        if (hugeLaserCooldown-- <= 0) {
            hugeLaserCooldown = HUGE_LASER_INTERVAL;
            fireEyeHugeLaser(target);
        }
        if (this.field_5974.method_43057() < 0.14f) tryStartEyeBurst(target, 8);
        if (lightningCooldown-- <= 0) {
            lightningCooldown = P3_ZONE_COOLDOWN;
            int delay = 0;
            for (int i = 0; i < PHASE3_BURST; i++) {
                class_2338 around = randomPosAround();
                class_2338 safe = safeStrikeAt(around);
                scheduleLightning(safe, TELEGRAPH_TICKS + delay);
                delay += 6;
            }
        }
        if (this.field_5974.method_43057() < 0.08f) tryShockwave(target);
        boolean near = this.method_5858(target) <= (LINE_TRIGGER_RANGE * LINE_TRIGGER_RANGE);
        if (near && this.field_5974.method_43057() < 0.07f) {
            scheduleLightningLineTowards(target, 12, 4);
        }
    }

    private boolean isEyeAlignedWith(class_1657 target) {
        float headYaw = this.method_5791();
        double dx = target.method_23317() - this.method_23317();
        double dz = target.method_23321() - this.method_23321();
        double bearingDeg = Math.toDegrees(Math.atan2(dz, dx)) - 90.0;
        double d = class_3532.method_15338(bearingDeg - headYaw);
        return Math.abs(d) <= ApostasyEntity.EYE_ALIGN_DEG;
    }

    private void tryStartEyeBurst(class_1657 target, int shots) {
        if (eyeBurstShotsLeft > 0) return;
        if (!isEyeAlignedWith(target)) return;
        eyeBurstShotsLeft = Math.max(1, shots);
    }

    private void tryShockwave(class_1657 target) {
        if (shockwaveCooldown > 0) return;
        spawnShockwaveAtPlayerY(target);
        shockwaveCooldown = switch (phase) {
            case P1 -> SHOCKWAVE_COOLDOWN_P1;
            case P2 -> SHOCKWAVE_COOLDOWN_P2;
            default -> SHOCKWAVE_COOLDOWN_P3;
        };
    }

    private void spawnShockwaveAtPlayerY(class_1657 target) {
        if (!(this.method_37908() instanceof class_3218 sw)) return;
        var e = net.kronoz.odyssey.init.ModEntities.SHOCKWAVE.method_5883(sw);
        if (e == null) return;

        double py = Math.floor(target.method_23318()) + 0.05; // spawn at player's level
        e.method_5808(this.method_23317(), py, this.method_23321(), 0, 0);

        e.setup(50f, 40, false); // false = ground wave (yOffset ~ 0.05)

        sw.method_8649(e);
    }

    @Override
    public boolean method_5655() {
        return false;
    }

    @Override
    public boolean method_5679(class_1282 source) {
        return false;
    }

    @Override
    public boolean method_5732() {
        return false;
    }

    @Override
    public boolean method_5810() {
        return false;
    }

    @Override
    public void method_5697(net.minecraft.class_1297 e) {
    }

    @Override
    public void method_6005(double s, double x, double z) {
    }

    @Override
    public void method_5762(double x, double y, double z) {
    }

    private class_2338 randomPosAround() {
        double a = this.field_5974.method_43058() * Math.PI * 2;
        int r = this.field_5974.method_39332(ApostasyEntity.PHASE3_MIN_R, ApostasyEntity.PHASE3_MAX_R);
        int x = class_3532.method_15357(method_23317() + Math.cos(a) * r);
        int z = class_3532.method_15357(method_23321() + Math.sin(a) * r);
        return new class_2338(x, method_31478(), z);
    }


    private int duration = 40;
    private boolean lightSpawned = false;
    private PointLightData bodyLight;
    private LightRenderHandle<PointLightData> bodyLightHandle;

    private void spawnVeilLight() {
        class_243 pos = this.method_19538();
        bodyLight = new PointLightData()
                .setPosition(pos.field_1352, pos.field_1351, pos.field_1350)
                .setRadius(200f)
                .setBrightness(2 * this.field_6012 * 200)
                .setColor(1f, 0.8f, 0.1f);
        bodyLightHandle = VeilRenderSystem.renderer().getLightRenderer().addLight(bodyLight);

        if (this.field_6012 > this.duration) {
            freeLight();
        }
    }

    private boolean playerOn(class_2338 pos) {
        return !this.method_37908().method_8390(class_1657.class, new class_238(pos).method_1014(1.5), p -> p.method_5805() && !p.method_7325()).isEmpty();
    }

    private class_2338 safeStrikeNear(class_2338 center) {
        for (int tries = 0; tries < 16; tries++) {
            double a = this.field_5974.method_43058() * Math.PI * 2;
            int r = this.field_5974.method_39332(2, 5);
            class_2338 candidate = center.method_10069(class_3532.method_15357(Math.cos(a) * r), 0, class_3532.method_15357(Math.sin(a) * r));
            class_2338 safe = safeStrikeAt(candidate);
            if (!playerOn(safe)) return safe;
        }
        return safeStrikeAt(center);
    }

    private class_2338 safeStrikeAt(class_2338 approx) {
        double x = approx.method_10263() + 0.5;
        double z = approx.method_10260() + 0.5;
        double yStart = this.method_23318() + 16.0;
        double yEnd = this.method_23318() - 64.0;
        var hit = this.method_37908().method_17742(new class_3959(new class_243(x, yStart, z), new class_243(x, yEnd, z), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, this));
        double y = hit.method_17783() == class_239.class_240.field_1332 ? hit.method_17784().field_1351 : this.method_37908().method_31607() + 1;
        return class_2338.method_49637(x, y, z);
    }

    private void scheduleLightning(class_2338 pos, int delay) {
        this.pendingStrikes.add(new PendingStrike(pos, delay));
    }

    private void tickPendingStrikes() {
        if (!(this.method_37908() instanceof class_3218 sw)) return;
        List<PendingStrike> next = new ArrayList<>(pendingStrikes.size());
        for (PendingStrike ps : pendingStrikes) {
            spawnGroundTelegraph(sw, ps.pos);
            ps.ticks--;
            if (ps.ticks <= 0) {
                class_2338 strikePos = ps.pos;
                if (!playerOn(strikePos)) {
                    class_1538 bolt = class_1299.field_6112.method_5883(sw);
                    if (bolt != null) {
                        bolt.method_29498(true);
                        bolt.method_29495(class_243.method_24955(strikePos));
                        sw.method_8649(bolt);
                        sw.method_43276(class_5712.field_28152, strikePos, class_5712.class_7397.method_43285(this));
                        causeDebrisOnLightning(sw, strikePos);
                    }
                }
            } else {
                next.add(ps);
            }
        }
        pendingStrikes.clear();
        pendingStrikes.addAll(next);
    }

    private void scheduleLightningLineTowards(class_1657 target, int nodes, int tickDelayStep) {
        class_2338 start = safeStrikeAt(class_2338.method_49637(method_23317(), method_23318(), method_23321()));
        class_243 startV = new class_243(start.method_10263() + 0.5, start.method_10264(), start.method_10260() + 0.5);
        class_2338 tgt = safeStrikeAt(target.method_24515());
        class_243 dir = new class_243(tgt.method_10263() + 0.5 - startV.field_1352, 0, tgt.method_10260() + 0.5 - startV.field_1350).method_1029();
        int delay = 0;
        for (int i = 0; i < nodes; i++) {
            class_243 p = startV.method_1019(dir.method_1021(4.0 * i));
            class_2338 pos = safeStrikeAt(class_2338.method_49637(p.field_1352, method_23318(), p.field_1350));
            if (!playerOn(pos)) {
                scheduleLightning(pos, TELEGRAPH_TICKS + delay);
                delay += tickDelayStep;
            }
        }
    }

    private void causeDebrisOnLightning(class_3218 sw, class_2338 strikePos) {
        java.util.ArrayList<class_2680> list = new java.util.ArrayList<>();
        class_2680 ground = groundStateAt(sw, strikePos);
        if (ground != null) list.add(ground);
        list.addAll(pullDownColumnBlocks(sw, strikePos, 12, 6));
        spawnDebrisCloud(sw, strikePos, list, 6);
    }

    private class_2680 groundStateAt(class_3218 sw, class_2338 pos) {
        class_2338 p = pos;
        for (int i = 0; i < 3; i++) {
            class_2680 st = sw.method_8320(p);
            if (!st.method_26215()) return st;
            p = p.method_10074();
        }
        return class_2246.field_10124.method_9564();
    }


    private java.util.List<class_2680> pullDownColumnBlocks(class_3218 sw, class_2338 pos, int scanUp, int maxPull) {
        java.util.ArrayList<class_2680> grabbed = new java.util.ArrayList<>();
        int pulled = 0;
        class_2338.class_2339 m = new class_2338.class_2339();
        for (int dy = 1; dy <= scanUp && pulled < maxPull; dy++) {
            m.method_10103(pos.method_10263(), pos.method_10264() + dy, pos.method_10260());
            var st = sw.method_8320(m);
            if (st.method_26215()) continue;
            var blk = st.method_26204();
            if (blk == class_2246.field_9987 || blk == class_2246.field_10499) continue;
            if (st.method_26220(sw, m).method_1110()) continue;
            sw.method_8652(m, class_2246.field_10124.method_9564(), 3);
            var f = net.minecraft.class_1540.method_40005(sw, m, st);
            f.field_7193 = false;
            try {
                f.method_49181();
            } catch (Throwable ignored) {
            }
            double spread = 0.35;
            f.method_18800(
                    (this.field_5974.method_43058() - 0.5) * spread,
                    -0.2 - this.field_5974.method_43058() * 0.2,
                    (this.field_5974.method_43058() - 0.5) * spread
            );
            grabbed.add(st);
            pulled++;
        }
        return grabbed;
    }

    private void spawnDebrisCloud(class_3218 sw, class_2338 pos, java.util.List<class_2680> states, int count) {
        for (int i = 0; i < count; i++) {
            var e = ModEntities.DEBRIS_BLOCK.method_5883(sw);
            if (e == null) continue;
            class_2680 st = states != null && !states.isEmpty()
                    ? states.get(this.field_5974.method_43048(states.size()))
                    : class_2246.field_10445.method_9564();
            e.init(st, 40 + this.field_5974.method_39332(0, 20));
            double ox = (this.field_5974.method_43058() - 0.5) * 1.8;
            double oz = (this.field_5974.method_43058() - 0.5) * 1.8;
            double oy = 0.4 + this.field_5974.method_43058() * 0.4;
            e.method_5808(pos.method_10263() + 0.5 + ox, pos.method_10264() + 0.6, pos.method_10260() + 0.5 + oz, 0, 0);
            e.method_18800(ox * 0.6, oy, oz * 0.6);
            float avx = (float) ((this.field_5974.method_43058() - 0.5) * 20.0);
            float avy = (float) ((this.field_5974.method_43058() - 0.5) * 20.0);
            float avz = (float) ((this.field_5974.method_43058() - 0.5) * 20.0);
            e.setAngularVelocity(avx, avy, avz);
            sw.method_8649(e);
        }
    }

    private void spawnGroundTelegraph(class_3218 sw, class_2338 pos) {
        var e = ModEntities.GROUND_DECAL.method_5883(sw);
        if (e == null) return;
        e.method_5808(pos.method_10263() + 0.5, pos.method_10264() + 0.01, pos.method_10260() + 0.5, 0, 0);
        e.setup(0.95, ApostasyEntity.TELEGRAPH_TICKS);
        sw.method_8649(e);
    }

    private void tickGlowHoming() {
        if (!(this.method_37908() instanceof net.minecraft.class_3218 sw)) return;
        if (glowShotCooldown > 0) {
            glowShotCooldown--;
            return;
        }

        net.minecraft.class_1657 target = getClosestTarget();
        if (target == null) return;

        java.util.List<net.minecraft.class_243> muzzles = getGlowMuzzles();
        if (muzzles.isEmpty()) return;

        if (glowMuzzleIndex >= muzzles.size()) glowMuzzleIndex = 0;
        net.minecraft.class_243 mCenter = muzzles.get(glowMuzzleIndex++);

        net.kronoz.odyssey.entity.projectile.LaserProjectileEntity rocket =
                net.kronoz.odyssey.init.ModEntities.LASER_PROJECTILE.method_5883(sw);
        if (rocket != null) {
            rocket.initHoming(this, target, mCenter, 0.6);
            rocket.setOdysseyDamage(1.0f);
            sw.method_8649(rocket);
        }

        glowShotCooldown = 10;
    }

    private java.util.List<net.minecraft.class_243> getGlowMuzzles() {
        double yawRad = net.minecraft.class_3532.field_29847 * (this.method_36454() % 360f);
        java.util.ArrayList<net.minecraft.class_243> out = new java.util.ArrayList<>(24);
        out.addAll(buildRingMuzzles(2.4, yawRad));
        out.addAll(buildRingMuzzles(3.1, yawRad * 0.97));
        out.addAll(buildRingMuzzles(3.8, yawRad * 0.94));
        return out;
    }

    private void fireEyeHugeLaser(class_1657 target) {
        if (!(this.method_37908() instanceof class_3218 sw)) return;
        class_243 eye = getEyeMuzzleCenter();
        class_243 aim = target.method_19538().method_1031(0, target.method_5751(), 0);
        class_243 dir = aim.method_1020(eye).method_1029();
        class_243 muzzle = eye.method_1019(dir.method_1021(0.6));
        LaserProjectileEntity beam = ModEntities.LASER_PROJECTILE.method_5883(sw);
        if (beam == null) return;
        beam.method_5808(muzzle.field_1352, muzzle.field_1351, muzzle.field_1350, 0, 0);
        beam.method_7432(this);
        beam.method_18799(dir.method_1021(HUGE_LASER_SPEED));
        beam.setOdysseyDamage(10f);
        sw.method_8649(beam);
    }

    private void fireRingsBurst(class_1657 target) {
        if (!(this.method_37908() instanceof class_3218 sw)) return;
        List<class_243> muzzles = getRingsMuzzles();
        class_243 aim = target.method_19538().method_1031(0, target.method_5751() * 0.6, 0);
        for (class_243 mCenter : muzzles) {
            class_243 dir = aim.method_1020(mCenter).method_1029();
            class_243 m = mCenter.method_1019(dir.method_1021(0.35));
            LaserProjectileEntity laser = ModEntities.LASER_PROJECTILE.method_5883(sw);
            if (laser == null) continue;
            laser.method_5808(m.field_1352, m.field_1351, m.field_1350, 0, 0);
            laser.method_7432(this);
            laser.method_18799(dir.method_1021(SMALL_LASER_SPEED));
            laser.setOdysseyDamage(3f);
            sw.method_8649(laser);
        }
    }

    private class_243 getEyeMuzzleCenter() {
        return this.method_19538().method_1031(0, this.method_5751() + 0.4, 0);
    }

    private List<class_243> getRingsMuzzles() {
        double yawRad = class_3532.field_29847 * (this.method_36454() % 360f);
        List<class_243> out = new ArrayList<>(24);
        out.addAll(buildRingMuzzles(RING1_R, yawRad));
        out.addAll(buildRingMuzzles(RING2_R, yawRad * 0.97));
        out.addAll(buildRingMuzzles(RING3_R, yawRad * 0.94));
        return out;
    }

    private List<class_243> buildRingMuzzles(double radius, double yawRad) {
        List<class_243> list = new ArrayList<>(8);
        class_243 center = this.method_19538().method_1031(0, RINGS_Y, 0);
        for (int i = 0; i < 8; i++) {
            double a = yawRad + (Math.PI * 2.0) * (i / (double) 8);
            double x = center.field_1352 + class_3532.method_15362((float) a) * radius;
            double z = center.field_1350 + class_3532.method_15374((float) a) * radius;
            list.add(new class_243(x, center.field_1351, z));
        }
        return list;
    }

    private boolean cutsceneActive = false;

    @Override
    public void method_5773() {
        super.method_5773();
        double targetY = groundYAt(method_23317(), method_23318(), method_23321()) + HOVER_OFFSET;
        double err = targetY - this.method_23318();
        hoverVy += HOVER_K * err - HOVER_D * hoverVy;
        hoverVy = class_3532.method_15350(hoverVy, -HOVER_MAX_VY, HOVER_MAX_VY);
        double vx = this.method_18798().field_1352 * 0.90;
        double vz = this.method_18798().field_1350 * 0.90;
        this.method_18800(vx, hoverVy, vz);
        this.method_5784(class_1313.field_6308, this.method_18798());
        if (this.field_5992 && hoverVy < 0) hoverVy = 0;
        this.field_6017 = 0f;
        this.method_5875(true);
        this.field_5960 = false;
        lastTargetY = targetY;

        if (this.method_37908().field_9236) {
            if (!lightSpawned) {
                spawnVeilLight();
                DeathUICutscene.start();

                net.minecraft.class_1657 target = getClosestTarget();
                if (target != null) {
                    cutsceneActive = true;
                }

                lightSpawned = true;
            }

            field_6012++;

            if (cutsceneActive && field_6012 >= this.duration) {
                net.minecraft.class_1657 target = getClosestTarget();

                cutsceneActive = false;
                freeLight();
            }


        }
    }

    @Override
    public void method_36209() {
        super.method_36209();
        freeLight();
    }


    private void freeLight() {
        if (bodyLightHandle != null && bodyLightHandle.isValid()) {
            bodyLightHandle.free();
        }
        bodyLightHandle = null;
        bodyLight = null;
    }

    private double groundYAt(double x, double yRef, double z) {
        class_243 start = new class_243(x, yRef + HOVER_SAMPLE_UP, z);
        class_243 end = new class_243(x, yRef - HOVER_SAMPLE_DOWN, z);
        var hit = this.method_37908().method_17742(new class_3959(start, end, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, this));
        if (hit.method_17783() == class_239.class_240.field_1332) return hit.method_17784().field_1351;
        return this.method_37908().method_31607() + 1.0;
    }

    @Override
    public void method_5768() {
        super.method_5768();
    }

    @Override
    public boolean method_5753() {
        return true;
    }

    @Override
    public boolean method_5643(net.minecraft.class_1282 source, float amount) {
        if (source.method_49708(net.minecraft.class_8111.field_42336)) return false;
        if (source.method_48789(net.minecraft.class_8103.field_42246)) return false;

        return super.method_5643(source, amount);
    }

    @Override
    public void method_5652(class_2487 nbt) {
        nbt.method_10582("Phase", phase.name());
        nbt.method_10569("cdRing", ringShotCooldown);
        nbt.method_10569("cdHuge", hugeLaserCooldown);
        nbt.method_10569("cdBolt", lightningCooldown);
        nbt.method_10569("cdShock", shockwaveCooldown);
        nbt.method_10549("hvVy", hoverVy);
        nbt.method_10549("lastTY", lastTargetY);
    }

    @Override
    public void method_5749(class_2487 nbt) {
        try {
            phase = Phase.valueOf(nbt.method_10558("Phase"));
        } catch (Exception ignored) {
        }
        ringShotCooldown = nbt.method_10550("cdRing");
        hugeLaserCooldown = nbt.method_10550("cdHuge");
        lightningCooldown = nbt.method_10550("cdBolt");
        if (nbt.method_10545("cdShock")) shockwaveCooldown = nbt.method_10550("cdShock");
        if (nbt.method_10545("hvVy")) hoverVy = nbt.method_10574("hvVy");
        if (nbt.method_10545("lastTY")) lastTargetY = nbt.method_10574("lastTY");
    }



    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    @Override
    public software.bernie.geckolib.animatable.instance.AnimatableInstanceCache getAnimatableInstanceCache() {
        return cache;
    }

}