package net.kronoz.odyssey.entity.apostasy;

import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;

public class ApostasyModel extends GeoModel<ApostasyEntity> {

    private static float wrapRad(float a) {
        a %= (float)(Math.PI * 2.0);
        if (a <= -Math.PI) a += (float)(Math.PI * 2.0);
        if (a >   Math.PI) a -= (float)(Math.PI * 2.0);
        return a;
    }

    private static float lerpAngleRad(float a, float b, float t) {
        float d = wrapRad(b - a);
        return a + d * t;
    }

    @Override
    public void setCustomAnimations(ApostasyEntity entity, long instanceId, AnimationState<ApostasyEntity> state) {
        super.setCustomAnimations(entity, instanceId, state);

        final float tickDelta = state.getPartialTick();

        float t = (entity.field_6012 + tickDelta) * 0.06f;
        long seed = entity.method_5667().getMostSignificantBits() ^ entity.method_5667().getLeastSignificantBits();
        GeoBone r1 = getAnimationProcessor().getBone("ring_1");
        GeoBone r2 = getAnimationProcessor().getBone("ring_2");
        GeoBone r3 = getAnimationProcessor().getBone("ring_3");
        if (r1 != null) { var a = ApostasyRingAnimator.angles(seed,"ring_1",t);       r1.setRotX(a.x); r1.setRotY(a.y); r1.setRotZ(a.z); }
        if (r2 != null) { var a = ApostasyRingAnimator.angles(seed,"ring_2",t*1.12f); r2.setRotX(a.x); r2.setRotY(a.y); r2.setRotZ(a.z); }
        if (r3 != null) { var a = ApostasyRingAnimator.angles(seed,"ring_3",t*0.91f); r3.setRotX(a.x); r3.setRotY(a.y); r3.setRotZ(a.z); }

        GeoBone head = getAnimationProcessor().getBone("mainhead");
        if (head == null || entity == null || entity.method_37908() == null) return;

        var world = entity.method_37908();
        var player = world.method_18460(entity, 64.0);
        if (player == null) {
            head.setRotZ(0);
            return;
        }

        double ex = class_3532.method_16436(tickDelta, entity.field_6014, entity.method_23317());
        double ey = class_3532.method_16436(tickDelta, entity.field_6036, entity.method_23318()) + entity.method_5751();
        double ez = class_3532.method_16436(tickDelta, entity.field_5969, entity.method_23321());

        double px = class_3532.method_16436(tickDelta, player.field_6014, player.method_23317());
        double py = class_3532.method_16436(tickDelta, player.field_6036, player.method_23318()) + player.method_5751();
        double pz = class_3532.method_16436(tickDelta, player.field_5969, player.method_23321());

        class_243 d = new class_243(px - ex, py - ey, pz - ez);

        float targetYaw  = (float)Math.atan2(d.field_1352, d.field_1350);
        float targetPitch= (float)-Math.atan2(d.field_1351, Math.sqrt(d.field_1352*d.field_1352 + d.field_1350*d.field_1350));


        targetPitch = -targetPitch;

        float curY = head.getRotY();
        float curX = head.getRotX();
        float smooth = 0.18f;

        float newY = lerpAngleRad(curY, targetYaw,   smooth);
        float newX = lerpAngleRad(curX, targetPitch, smooth);

        float maxPitch = (float)Math.toRadians(45);
        newX = class_3532.method_15363(newX, -maxPitch, maxPitch);

        head.setRotY(newY);
        head.setRotX(newX);
        head.setRotZ(0);
    }

    @Override public class_2960 getModelResource(ApostasyEntity a){ return class_2960.method_60655("odyssey","geo/entity/apostasy.geo.json"); }
    @Override public class_2960 getTextureResource(ApostasyEntity a){ return class_2960.method_60655("odyssey","textures/entity/apostasy.png"); }
    @Override public class_2960 getAnimationResource(ApostasyEntity a){ return class_2960.method_60655("odyssey","animations/entity/apostasy.animation.json"); }
}