package net.kronoz.odyssey.entity.arcangel;

import net.kronoz.odyssey.entity.apostasy.ApostasyEntity;
import net.kronoz.odyssey.init.ModSounds;
import net.kronoz.odyssey.systems.cam.ClientFx;
import net.kronoz.odyssey.systems.cam.RapidShake;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.*;
import software.bernie.geckolib.util.GeckoLibUtil;

import java.util.Comparator;
import java.util.List;
import java.util.UUID;

public class ArcangelEntity extends class_1314 implements GeoEntity {
// also don't ask why it's a path aware entity XD, it just is caus minecraft. (idk either) -Dark
    // === Synced flags/data ===
    public static final class_2940<Boolean> SHOOTING =
            class_2945.method_12791(ArcangelEntity.class, class_2943.field_13323);
    public static final class_2940<Integer> BLOOD =
            class_2945.method_12791(ArcangelEntity.class, class_2943.field_13327);

    // === Anim clips ===
    private static final RawAnimation IDLE  = RawAnimation.begin().thenLoop("idle");
    private static final RawAnimation SHOOT = RawAnimation.begin().thenPlay("shoot");

    private boolean prevShootingClient;

    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache(this);
    private static final int SHAKE_DELAY_TICKS = 40; // 2.5s à 20 TPS

    private int shakeDelayClient = -1;
    private boolean shakeFiredThisShot = false;    private static final int SHOOT_DURATION_TICKS = 80;
    private static final int DAMAGE_HIT_TICKS     = 60;
    private static final float ARCANGEL_DAMAGE    = 150.0f;

    private int shootingTicks;
    private boolean playedShootSfx;
    @Nullable private UUID lockedTarget;
    private float fullBodyYawDeg;
    private float headPitchDeg;
    private float recoilRad;
    private float bodyYawTargetDeg;
    private float headPitchTargetDeg;

    public ArcangelEntity(class_1299<? extends class_1314> type, class_1937 world) {
        super(type, world);
        this.method_5875(true);
        this.method_5971();
        this.method_5977(true);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1314.method_26827()
                .method_26868(class_5134.field_23716, 40.0)
                .method_26868(class_5134.field_23719, 0.0)
                .method_26868(class_5134.field_23718, 1.0)
                .method_26868(class_5134.field_23717, 32.0);
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(SHOOTING, false);
        builder.method_56912(BLOOD, 0);
    }

    // ======= External blood feed =======
    public void addBlood(int amount) {
        if (this.method_37908().field_9236) {
            this.field_6011.method_12789(BLOOD);
            return;
        }
        int cur = class_3532.method_15340(this.field_6011.method_12789(BLOOD) + amount, 0, 100);
        this.field_6011.method_12778(BLOOD, cur);
        if (cur >= 100) {
            startShooting();
            this.field_6011.method_12778(BLOOD, 0);
        }
        this.field_6011.method_12789(BLOOD);
    }


    // ======= Shoot sequence =======
    public void startShooting() {
        if (this.method_37908().field_9236) return;
        if (!this.field_6011.method_12789(SHOOTING)) {
            this.field_6011.method_12778(SHOOTING, true);
            this.shootingTicks = SHOOT_DURATION_TICKS;
            this.playedShootSfx = false;

            ApostasyEntity target = findNearestApostasyUnlimited();
            this.lockedTarget = (target != null) ? target.method_5667() : null;

            updateAimTargets(target);
            this.recoilRad = 0.35f;
        }
    }

    @Override
    public void method_5773() {
        super.method_5773();

        this.method_18799(class_243.field_1353);
        this.field_6017 = 0f;

        ApostasyEntity visibleTarget = resolveLockedTarget();
        if (visibleTarget == null) {
            visibleTarget = findNearestApostasyUnlimited();
        }
        updateAimTargets(visibleTarget);

        this.fullBodyYawDeg = approachAngleDeg(this.fullBodyYawDeg, this.bodyYawTargetDeg);
        this.headPitchDeg   = class_3532.method_16439(0.2f, this.headPitchDeg, this.headPitchTargetDeg);

        if (this.recoilRad > 0f) {
            this.recoilRad *= 0.88f;
            if (this.recoilRad < 0.005f) this.recoilRad = 0f;
        }
        if (this.method_37908().field_9236) {
            boolean now = this.field_6011.method_12789(SHOOTING);

            if (now && !prevShootingClient) {
                shakeDelayClient = SHAKE_DELAY_TICKS;
                shakeFiredThisShot = false;
            }

            if (now && shakeDelayClient >= 0) {
                if (shakeDelayClient-- == 0 && !shakeFiredThisShot) {
                    net.kronoz.odyssey.systems.cam.ClientFx.rapidShakeStart(200.75f, 40);
                    shakeFiredThisShot = true;
                }
            }

            if (!now) {
                shakeDelayClient = -1;
                shakeFiredThisShot = false;
            }

            prevShootingClient = now;
        }
        if (!this.method_37908().field_9236) {
            if (this.field_6011.method_12789(SHOOTING)) {
                if (shootingTicks == DAMAGE_HIT_TICKS) {
                    ApostasyEntity target = resolveLockedTarget();
                    if (target == null) target = findNearestApostasyUnlimited();
                    if (target != null && target.method_5805()) {
                        target.method_5643((this.method_37908()).method_48963().method_48812(this), ARCANGEL_DAMAGE);
                    }
                }
            }
        }
        if (!this.method_37908().field_9236) {
            if (this.field_6011.method_12789(SHOOTING)) {
                if (!playedShootSfx) {
                    playedShootSfx = true;
                    var sound = (ModSounds.ARC_SHOOT != null)
                            ? ModSounds.ARC_SHOOT
                            : class_3417.field_14880;
                    this.method_37908().method_8396(null, this.method_24515(), sound, class_3419.field_15251, 1.0f, 1.0f);
                }

                if (shootingTicks == DAMAGE_HIT_TICKS) {
                    ApostasyEntity target = resolveLockedTarget();
                    if (target == null) target = findNearestApostasyUnlimited();
                    if (target != null && target.method_5805()) {
                        target.method_5643((this.method_37908()).method_48963().method_48812(this), ARCANGEL_DAMAGE);
                    }
                }


                if (--shootingTicks <= 0) {
                    this.field_6011.method_12778(SHOOTING, false);
                    this.lockedTarget = null;
                }
            }
        }
    }

    // ======= Aiming helpers =======
    @Nullable
    private ApostasyEntity resolveLockedTarget() {
        if (lockedTarget == null) return null;
        List<ApostasyEntity> list = this.method_37908().method_8390(
                ApostasyEntity.class,
                this.method_5829().method_1014(1_000_000.0), // effectively global
                e -> e.method_5667().equals(lockedTarget) && e.method_5805()
        );
        return list.isEmpty() ? null : list.getFirst();
    }

    private static float approachAngleDeg(float current, float target) {
        float delta = class_3532.method_15393(target - current);
        if (delta > (float) 6.0) delta = (float) 6.0;
        if (delta < -(float) 6.0) delta = -(float) 6.0;
        return current + delta;
    }

    private void updateAimTargets(@Nullable ApostasyEntity t) {
        if (t == null) return;
        class_243 d = t.method_33571().method_1020(this.method_33571());
        this.bodyYawTargetDeg  = (float) Math.toDegrees(Math.atan2(-d.field_1352, d.field_1350));
        this.headPitchTargetDeg = (float) (-Math.toDegrees(Math.atan2(d.field_1351, Math.sqrt(d.field_1352*d.field_1352 + d.field_1350*d.field_1350))));
    }


    @Nullable
    private ApostasyEntity findNearestApostasyUnlimited() {
        class_238 huge = this.method_5829().method_1014(1_000_000.0); // ~infinite for practical purposes
        List<ApostasyEntity> list = this.method_37908().method_8390(ApostasyEntity.class, huge, class_1309::method_5805);
        return list.stream().min(Comparator.comparingDouble(this::method_5858)).orElse(null);
    }

    // ======= Geckolib =======
    private <E extends ArcangelEntity> PlayState controller(AnimationState<E> state) {
        if (this.field_6011.method_12789(SHOOTING)) {
            state.setAnimation(SHOOT);
            return PlayState.CONTINUE;
        }
        state.setAnimation(IDLE);
        return PlayState.CONTINUE;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController<>(this, "main", 0, this::controller));
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return cache;
    }

    @Override
    public double getTick(Object o) {
        return this.field_6012;
    }

    // ======= Model hooks =======
    public float getFullBodyYaw() { return this.fullBodyYawDeg; }
    public float getHeadPitchDeg() { return this.headPitchDeg; }
    public float getRecoilRad() { return this.recoilRad; }

    // ======= Save/Load =======
    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.shootingTicks = nbt.method_10550("ShootingTicks");
        this.field_6011.method_12778(SHOOTING, nbt.method_10577("Shooting"));
        this.field_6011.method_12778(BLOOD, class_3532.method_15340(nbt.method_10550("Blood"), 0, 100));
        this.playedShootSfx = nbt.method_10577("PlayedShootSfx");
        this.fullBodyYawDeg = nbt.method_10583("FullBodyYawDeg");
        this.headPitchDeg = nbt.method_10583("HeadPitchDeg");
        this.recoilRad = nbt.method_10583("RecoilRad");
        this.bodyYawTargetDeg = nbt.method_10583("BodyYawTargetDeg");
        this.headPitchTargetDeg = nbt.method_10583("HeadPitchTargetDeg");
        this.lockedTarget = nbt.method_25928("LockedTarget") ? nbt.method_25926("LockedTarget") : null;
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("ShootingTicks", this.shootingTicks);
        nbt.method_10556("Shooting", this.field_6011.method_12789(SHOOTING));
        nbt.method_10569("Blood", this.field_6011.method_12789(BLOOD));
        nbt.method_10556("PlayedShootSfx", this.playedShootSfx);
        nbt.method_10548("FullBodyYawDeg", this.fullBodyYawDeg);
        nbt.method_10548("HeadPitchDeg", this.headPitchDeg);
        nbt.method_10548("RecoilRad", this.recoilRad);
        nbt.method_10548("BodyYawTargetDeg", this.bodyYawTargetDeg);
        nbt.method_10548("HeadPitchTargetDeg", this.headPitchTargetDeg);
        if (this.lockedTarget != null) nbt.method_25927("LockedTarget", this.lockedTarget);
    }

    // ======= Extra immobility =======
    @Override public boolean method_5810() { return false; }
    @Override public boolean method_5675() { return false; } //why is mojang like this :(
    @Override public void method_6005(double s, double x, double z) { /* no-op */ }
    @Override public void method_6091(class_243 in) { this.method_18799(class_243.field_1353); }
    @Override public boolean method_17326() {return true;}
    @Override protected boolean method_23734() {return false;}
    @Override public boolean method_5947() {return true;}
}