package net.kronoz.odyssey.entity.arcangel;

import net.minecraft.class_2960;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;

public class ArcangelModel extends GeoModel<ArcangelEntity> {
    @Override
    public class_2960 getModelResource(ArcangelEntity animatable) {
        return class_2960.method_60655("odyssey", "geo/entity/arcangel.geo.json");
    }

    @Override
    public class_2960 getTextureResource(ArcangelEntity animatable) {
        return class_2960.method_60655("odyssey", "textures/entity/arcangel.png");
    }

    @Override
    public class_2960 getAnimationResource(ArcangelEntity animatable) {
        return class_2960.method_60655("odyssey", "animations/entity/arcangel.animation.json");
    }

    @Override
    public void setCustomAnimations(ArcangelEntity e, long id, AnimationState<ArcangelEntity> state) {
        GeoBone full = getAnimationProcessor().getBone("full");
        GeoBone head = getAnimationProcessor().getBone("head");

        if (full != null) {
            full.setRotY((float) Math.toRadians(-e.getFullBodyYaw()));
        }
        if (head != null) {
            float baseX = (float) Math.toRadians(-e.getHeadPitchDeg());
            head.setRotX(baseX + e.getRecoilRad());
        }
    }
}