package net.kronoz.odyssey.entity.arcangel;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;

import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.light.data.PointLightData;
import foundry.veil.api.client.render.light.renderer.LightRenderHandle;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

import net.kronoz.odyssey.Odyssey;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import org.joml.Vector4f;

import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.cache.object.GeoCube;
import software.bernie.geckolib.renderer.specialty.DynamicGeoEntityRenderer;

@Environment(EnvType.CLIENT)
public class ArcangelRenderer extends DynamicGeoEntityRenderer<ArcangelEntity> {

    private static final String LASER_BONE = "truelaser";

    private final Int2ObjectMap<LightRenderHandle<PointLightData>> handles = new Int2ObjectOpenHashMap<>();
    private final Int2ObjectMap<PointLightData> datas = new Int2ObjectOpenHashMap<>();

    private final Int2ObjectMap<float[]> lastBonePos = new Int2ObjectOpenHashMap<>();
    private final Int2ObjectMap<Boolean> boneSeenThisFrame = new Int2ObjectOpenHashMap<>();

    private static final float L_R = 1.0f, L_G = 0.0f, L_B = 0.0f; // red
    private static final float L_BRIGHT = 20.2f;
    private static final float L_RADIUS = 70.5f;

    public ArcangelRenderer(net.minecraft.class_5617.class_5618 ctx) {
        super(ctx, new ArcangelModel());
        this.field_4673 = 0.4f;
    }

    @Override
    public class_2960 getTextureLocation(ArcangelEntity animatable) {
        return new ArcangelModel().getTextureResource(animatable);
    }

    @Override
    protected boolean boneRenderOverride(class_4587 poseStack,
                                         GeoBone bone,
                                         class_4597 bufferSource,
                                         class_4588 buffer,
                                         float partialTick,
                                         int packedLight,
                                         int packedOverlay,
                                         int colour) {

        if (LASER_BONE.equals(bone.getName())) {
            var m = poseStack.method_23760().method_23761();
            // origin (0,0,0) of this bone in world
            Vector4f p = new Vector4f(0f, 0f, 0f, 1f).mul(m);
            int id = this.getAnimatable().method_5628();
            lastBonePos.put(id, new float[]{p.x, p.y, p.z});
            boneSeenThisFrame.put(id, Boolean.TRUE);
        }

        boolean isEmissive = bone.getName().equals("gem") ||
                bone.getName().equals("gemlight") ||
                bone.getName().startsWith("laserring") ||
                bone.getName().equals("laser");

        class_4588 vc;
        if (isEmissive) {
            vc = bufferSource.getBuffer(
                    class_1921.method_23026(class_2960.method_60655(Odyssey.MODID, "textures/entity/arcangel.png"))
            );
            packedLight = 15728880;
        } else {
            vc = bufferSource.getBuffer(class_1921.method_23576(getTextureLocation(this.getAnimatable())));
        }

        if (!bone.isHidden()) {
            poseStack.method_22903();
            for (GeoCube cube : bone.getCubes()) {
                renderCube(poseStack, cube, vc, packedLight, class_4608.field_21444, colour);
            }
            poseStack.method_22909();
        }

        return true;
    }

    @Override
    public void render(ArcangelEntity entity, float entityYaw, float tickDelta,
                       class_4587 matrices, class_4597 buffers, int packedLight) {

        boneSeenThisFrame.put(entity.method_5628(), Boolean.FALSE);

        super.method_3936(entity, entityYaw, tickDelta, matrices, buffers, packedLight);

        applyVeilLightFor(entity);
    }

    private void applyVeilLightFor(ArcangelEntity e) {
        var sys = VeilRenderSystem.renderer();
        boolean shooting = e.method_5841().method_12789(ArcangelEntity.SHOOTING);

        if (sys == null || sys.getLightRenderer() == null || !shooting) {
            killLight(e);
            return;
        }

        Boolean seen = boneSeenThisFrame.get(e.method_5628());
        float[] pos = lastBonePos.get(e.method_5628());

        if (seen == null || !seen || pos == null) {
            killLight(e);
            return;
        }

        float wx = pos[0], wy = pos[1], wz = pos[2];

        LightRenderHandle<PointLightData> h = handles.get(e.method_5628());
        PointLightData d = datas.get(e.method_5628());

        if (h == null || d == null || !h.isValid()) {
            d = new PointLightData()
                    .setBrightness(L_BRIGHT)
                    .setColor(L_R, L_G, L_B)
                    .setRadius(L_RADIUS);
            d.setPosition(wx, wy, wz);
            h = sys.getLightRenderer().addLight(d);
            handles.put(e.method_5628(), h);
            datas.put(e.method_5628(), d);
        } else {
            d.setBrightness(L_BRIGHT);
            d.setColor(L_R, L_G, L_B);
            d.setRadius(L_RADIUS);
            d.setPosition(wx, wy, wz);
            h.markDirty();
        }
    }

    private void killLight(ArcangelEntity e) {
        LightRenderHandle<PointLightData> h = handles.remove(e.method_5628());
        if (h != null && h.isValid()) h.close();
        datas.remove(e.method_5628());
        lastBonePos.remove(e.method_5628());
        boneSeenThisFrame.remove(e.method_5628());
    }
}
