package net.kronoz.odyssey.entity.sentinel;

import java.util.EnumSet;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_5819;

public class SentinelFollowPlayerGoal extends class_1352 {
    private final SentinelEntity mob;
    private class_1657 target;
    private int roamCooldown;
    private double hoverPhase;
    private int memoryTicks;
    private class_243 lastSeenPos;

    private static final double HOVER_UP = 2.25;
    private static final double HOVER_RADIUS = 1.75;
    private static final double SPEED_APPROACH = 1.0;
    private static final double SPEED_HOVER = 0.9;
    private static final double SPEED_ROAM = 0.7;
    private static final int MEMORY_MAX_TICKS = 60;

    public SentinelFollowPlayerGoal(SentinelEntity mob) {
        this.mob = mob;
        this.method_6265(EnumSet.of(class_4134.field_18405));
    }

    @Override public boolean method_6264() { return true; }

    @Override
    public void method_6268() {
        hoverPhase += 0.05;
        if (roamCooldown > 0) roamCooldown--;

        if (target == null || !target.method_5805() || target.method_7325() || target.method_7337())
            target = mob.getTrackedPlayer();

        double hover = Math.sin(hoverPhase) * 0.45;

        if (target != null) {
            boolean visible = mob.canSeePlayerInCone(target);
            mob.setSpotted(visible);

            class_243 tp = target.method_33571().method_1031(0, HOVER_UP, 0);
            if (visible) {
                memoryTicks = MEMORY_MAX_TICKS;
                lastSeenPos = tp;
                class_243 me = mob.method_19538();
                class_243 dir = tp.method_1020(me);
                double d = dir.method_1033();
                if (d > HOVER_RADIUS + 0.5) {
                    mob.steerTowards(tp.method_1031(0, hover, 0), SPEED_APPROACH);
                } else if (d < HOVER_RADIUS - 0.5) {
                    class_243 away = me.method_1020(tp).method_1029();
                    class_243 pos = tp.method_1019(away.method_1021(HOVER_RADIUS)).method_1031(0, hover, 0);
                    mob.steerTowards(pos, SPEED_HOVER);
                } else {
                    mob.steerTowards(tp.method_1031(0, hover * 0.5, 0), SPEED_HOVER);
                }
            } else if (memoryTicks > 0 && lastSeenPos != null) {
                memoryTicks--;
                mob.steerTowards(lastSeenPos.method_1031(0, hover, 0), SPEED_HOVER);
            } else {
                if (roamCooldown == 0) {
                    class_243 me = mob.method_19538();
                    class_243 roam = me.method_1031(rand(mob.method_59922(), 8), rand(mob.method_59922(), 4), rand(mob.method_59922(), 8));
                    mob.steerTowards(roam, SPEED_ROAM);
                    roamCooldown = 25;
                }
            }
        } else {
            mob.setSpotted(false);
            if (roamCooldown == 0) {
                class_243 me = mob.method_19538();
                class_243 roam = me.method_1031(rand(mob.method_59922(), 8), rand(mob.method_59922(), 4), rand(mob.method_59922(), 8));
                mob.steerTowards(roam, SPEED_ROAM);
                roamCooldown = 25;
            }
        }
    }

    private static double rand(class_5819 r, int range) {
        return class_3532.method_15366(r, -range, range);
    }
}
