package net.kronoz.odyssey.entity.sentinel;

import java.util.EnumSet;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_3532;

public class SentinelLookGoal extends class_1352 {
    private final SentinelEntity mob;
    private static final float HEAD_SMOOTH = 0.18f;
    private static final float EYE_SMOOTH = 0.2f;
    private static final float PITCH_DEADZONE = (float)Math.toRadians(1.0);

    private float scanEyeYaw = 0f;
    private float scanEyePitch = 0f;
    private int scanTicksLeft = 0;

    public SentinelLookGoal(SentinelEntity mob) {
        this.mob = mob;
        this.method_6265(EnumSet.of(class_4134.field_18406));
    }

    @Override public boolean method_6264() { return true; }

    @Override
    public void method_6268() {
        class_1657 p = mob.getTrackedPlayer();
        boolean visible = p != null && mob.canSeePlayerInCone(p);
        mob.setSpotted(visible);

        if (visible && p != null) {
            class_243 from = mob.method_33571();
            class_243 to = p.method_33571().method_1031(0, 0.2, 0);
            class_243 d = to.method_1020(from);
            double dx = d.field_1352, dy = d.field_1351, dz = d.field_1350;
            double flat = Math.sqrt(dx*dx + dz*dz);

            float targetHeadPitch = (float)Math.atan2(dy, flat);
            targetHeadPitch = class_3532.method_15363(targetHeadPitch, SentinelEntity.HEAD_PITCH_MIN, SentinelEntity.HEAD_PITCH_MAX);
            float curHead = mob.getHeadPitch();
            float diff = targetHeadPitch - curHead;
            if (Math.abs(diff) > PITCH_DEADZONE) mob.setHeadPitch(curHead + diff * HEAD_SMOOTH);

            float bodyYawDeg = mob.method_36454();
            float targetYawDeg = (float)(Math.toDegrees(Math.atan2(dz, dx)) - 90f);
            float localYawDeg = class_3532.method_15393(targetYawDeg - bodyYawDeg);
            float eyeYaw = (float)Math.toRadians(localYawDeg);
            eyeYaw = class_3532.method_15363(eyeYaw, SentinelEntity.EYE_YAW_MIN, SentinelEntity.EYE_YAW_MAX);

            float eyePitch = (float)Math.atan2(dy, flat);
            eyePitch = class_3532.method_15363(eyePitch, SentinelEntity.EYE_PITCH_MIN, SentinelEntity.EYE_PITCH_MAX);

            float curY = mob.getEyeYaw();
            float curP = mob.getEyePitch();
            mob.setEye(curY + (eyeYaw - curY) * EYE_SMOOTH, curP + (eyePitch - curP) * EYE_SMOOTH);

            scanTicksLeft = 0;
        } else {
            if (scanTicksLeft <= 0) {
                ThreadLocalRandom r = ThreadLocalRandom.current();
                float yawRange   = (SentinelEntity.EYE_YAW_MAX - SentinelEntity.EYE_YAW_MIN) * 0.6f;
                float pitchRange = (SentinelEntity.EYE_PITCH_MAX - SentinelEntity.EYE_PITCH_MIN) * 0.6f;
                float yawCenter   = (SentinelEntity.EYE_YAW_MAX + SentinelEntity.EYE_YAW_MIN) * 0.5f;
                float pitchCenter = (SentinelEntity.EYE_PITCH_MAX + SentinelEntity.EYE_PITCH_MIN) * 0.5f;
                scanEyeYaw   = yawCenter   + (float)((r.nextDouble() - 0.5) * yawRange);
                scanEyePitch = pitchCenter + (float)((r.nextDouble() - 0.5) * pitchRange);
                scanTicksLeft = r.nextInt(40, 71);
            } else scanTicksLeft--;

            float hp = mob.getHeadPitch();
            mob.setHeadPitch(hp + (0f - hp) * 0.12f);

            float curY = mob.getEyeYaw();
            float curP = mob.getEyePitch();
            mob.setEye(curY + (scanEyeYaw - curY) * 0.12f, curP + (scanEyePitch - curP) * 0.12f);
        }
    }
}
