package net.kronoz.odyssey.entity.sentry;

import java.util.EnumSet;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_3532;

public class SentryLookGoal extends class_1352 {
    private final SentryEntity mob;
    private static final float HEAD_SMOOTH = 0.18f;
    private static final float EYE_SMOOTH  = 0.2f;
    private static final float PITCH_DEADZONE = (float)Math.toRadians(1.0);

    private float scanEyeYaw = 0f;
    private float scanEyePitch = 0f;
    private int scanTicksLeft = 0;

    public SentryLookGoal(SentryEntity mob) {
        this.mob = mob;
        this.method_6265(EnumSet.of(class_4134.field_18406));
    }

    @Override public boolean method_6264() { return true; }

    @Override
    public void method_6268() {
        class_1657 nearest = mob.method_37908().method_18460(mob, 32.0);
        if (nearest != null && !nearest.method_7325() && !nearest.method_7337()) {
            boolean hasWeakness = nearest.method_6059(net.minecraft.class_1294.field_5911);
            lookAt(nearest, hasWeakness);
        } else {
            scan();
        }
    }

    private void lookAt(class_1657 p, boolean aggressive) {
        class_243 from = mob.method_33571();
        class_243 to = p.method_33571();
        class_243 d = to.method_1020(from);
        double dx = d.field_1352, dy = d.field_1351, dz = d.field_1350;
        double flat = Math.sqrt(dx*dx + dz*dz);

        float targetHeadPitch = (float)Math.atan2(dy, flat);
        targetHeadPitch = class_3532.method_15363(targetHeadPitch, SentryEntity.HEAD_PITCH_MIN, SentryEntity.HEAD_PITCH_MAX);
        float curHead = mob.getHeadPitch();
        float diff = targetHeadPitch - curHead;
        if (Math.abs(diff) > PITCH_DEADZONE) mob.setHeadPitch(curHead + diff * HEAD_SMOOTH);

        float bodyYawDeg = mob.method_36454();
        float targetYawDeg = (float)(Math.toDegrees(Math.atan2(dz, dx)) - 90f);
        float localYawDeg = class_3532.method_15393(targetYawDeg - bodyYawDeg);
        float eyeYaw = (float)Math.toRadians(localYawDeg);
        eyeYaw = class_3532.method_15363(eyeYaw, SentryEntity.EYE_YAW_MIN, SentryEntity.EYE_YAW_MAX);

        float eyePitch = (float)Math.atan2(dy, flat);
        eyePitch = class_3532.method_15363(eyePitch, SentryEntity.EYE_PITCH_MIN, SentryEntity.EYE_PITCH_MAX);

        float curY = mob.getEyeYaw();
        float curP = mob.getEyePitch();
        float s = aggressive ? EYE_SMOOTH : 0.18f;
        mob.setEye(curY + (eyeYaw - curY) * s, curP + (eyePitch - curP) * s);
    }

    private void scan() {
        if (scanTicksLeft <= 0) {
            ThreadLocalRandom r = ThreadLocalRandom.current();
            float yawRange   = (SentryEntity.EYE_YAW_MAX - SentryEntity.EYE_YAW_MIN) * 0.6f;
            float pitchRange = (SentryEntity.EYE_PITCH_MAX - SentryEntity.EYE_PITCH_MIN) * 0.6f;
            float yawCenter   = (SentryEntity.EYE_YAW_MAX + SentryEntity.EYE_YAW_MIN) * 0.5f;
            float pitchCenter = (SentryEntity.EYE_PITCH_MAX + SentryEntity.EYE_PITCH_MIN) * 0.5f;
            scanEyeYaw   = yawCenter   + (float)((r.nextDouble() - 0.5) * yawRange);
            scanEyePitch = pitchCenter + (float)((r.nextDouble() - 0.5) * pitchRange);
            scanTicksLeft = r.nextInt(40, 71);
        } else scanTicksLeft--;

        float hp = mob.getHeadPitch();
        mob.setHeadPitch(hp + (0f - hp) * 0.12f);

        float curY = mob.getEyeYaw();
        float curP = mob.getEyePitch();
        mob.setEye(curY + (scanEyeYaw - curY) * 0.12f, curP + (scanEyePitch - curP) * 0.12f);
    }
}
