package net.kronoz.odyssey.entity.souls;

import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.light.data.PointLightData;
import foundry.veil.api.client.render.light.renderer.LightRenderHandle;
import net.kronoz.odyssey.init.ModParticles;
import net.kronoz.odyssey.systems.cinematics.api.Easing;
import net.kronoz.odyssey.systems.cinematics.api.RotationTweener;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1429;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_7094;
import net.minecraft.class_8111;
import net.minecraft.util.math.*;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.animation.*;

import java.util.List;
import java.util.Random;
import java.util.UUID;




public class LoveEntity extends class_1429 implements GeoEntity {
    public final class_7094 idleAnimationState = new class_7094();
    private int idleAnimationTimeout = 0;

    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache(this);

    private static final float BODY_LIGHT_BRIGHTNESS = 1.5f;
    private static final float BODY_LIGHT_RADIUS     = 13f;
    private static final float BODY_R = 0.70f, BODY_G = 0.70f, BODY_B = 0.10f;

    private PointLightData bodyLight;
    private LightRenderHandle<PointLightData> bodyLightHandle;

    private int spawnAge = -1;
    private int maxLifeTicks = 0;
    private UUID ownerUuid = null;

    private double hitboxSize = 1.0;
    private final double growthRate = 0.12;
    private final double minSize = 0.6;
    private final double maxSize = 2.5;





    float minRandom = 1.3f;
    float maxRandom = 2.0f;

    Random random = new Random();

    float pitch = minRandom + random.nextFloat() * (maxRandom - minRandom);

// distance fom owner




    public LoveEntity(class_1299<? extends class_1429> type, class_1937 world) {
        super(type, world);
        this.field_5985 = true;






    }





    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828()
                .method_26868(class_5134.field_23716, 15.0)
                .method_26868(class_5134.field_23720, 0.6F)
                .method_26868(class_5134.field_23719, 0.2F);
    }

    public void setOwner(@Nullable class_1309 owner) {
        this.ownerUuid = owner != null ? owner.method_5667() : null;
    }



    @Nullable
    public class_1297 getOwnerEntity() {
        if (ownerUuid == null) return null;
        if (!(this.method_37908() instanceof class_3218 sw)) return null;
        return sw.method_14190(ownerUuid);
    }

    @Override
    protected void method_5959() {}

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = 15;
            this.idleAnimationState.method_41322(this.field_6012);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    @Override
    public void method_6005(double strength, double x, double z) {
    }


    @Override
    public void method_5773() {

        super.method_5773();

        if (!this.method_37908().field_9236) {
            class_2338 below = this.method_24515().method_10074();


            int power = this.method_37908().method_49804(below);

float targetYaw = this.method_37908().method_49804(below);
          float currentSpinSpeed = (float) (power * 0.1f * 100f);

            RotationTweener tweener = new RotationTweener(
      this.method_36454(), this.method_36455(),  // start yaw/pitch
      targetYaw, this.pitch,              // target yaw/pitch
     power * 1,                                  // duration in ticks (2 seconds at 20 TPS)
       Easing.IN_OUT_SINE );                  // easing type


// in a tick handler or goal tick
if (!tweener.isDone()) {
       tweener.tick((yaw, pitch) -> {
      this.method_36456(yaw);
       this.method_36457(pitch);
    });
           }





            this.method_36456(this.method_36454() - currentSpinSpeed);
           this.method_5636(this.method_36454());
           this.method_5847(this.method_36454());


           if (this.method_36454() > 360f || this.method_36454() < -360f) {
               this.method_36456(0f);
          }
       }

        if (this.method_37908().field_9236) {
            setupAnimationStates();
            boolean alive = this.method_5805() && !this.method_31481();
            if (alive) {
                if (bodyLightHandle == null || !bodyLightHandle.isValid()) {
                    class_243 p = this.method_19538();
                    bodyLight = new PointLightData()
                            .setBrightness(BODY_LIGHT_BRIGHTNESS)
                            .setColor(BODY_R, BODY_G, BODY_B)
                            .setRadius(BODY_LIGHT_RADIUS)
                            .setPosition(p.field_1352, p.field_1351, p.field_1350);
                    bodyLightHandle = VeilRenderSystem.renderer().getLightRenderer().addLight(bodyLight);
                } else {
                    class_243 p = this.method_19538();
                    bodyLight.setPosition(p.field_1352, p.field_1351, p.field_1350);
                    bodyLightHandle.markDirty();
                }
            } else {
                freeLight();
            }
        }
    }



    private void explodeAndRemove() {
        if (this.method_37908() instanceof class_3218 sw) {


            sw.method_14199(class_2398.field_29644, method_23317(), method_23318() + 3, method_23321(), 10, 0, 0, 0, 0);
            sw.method_45445(this, method_24515(), class_3417.field_38369, class_3419.field_15256, 10, pitch
            );




        }
        this.method_31472();
    }

    private void freeLight() {
        if (bodyLightHandle != null && bodyLightHandle.isValid()) {
            bodyLightHandle.free();
        }
        bodyLightHandle = null;
        bodyLight = null;
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        if (source.method_49708(class_8111.field_42347) || amount > 5000) {

            return super.method_5643(source, amount);


        } else {
            return false;
        }
    }

    @Override
    public boolean method_5810() {
        return false;
    }
    @Override
    protected void method_6087(class_1297 entity) {}

    @Override public boolean method_6481(class_1799 stack) { return false; }
    @Nullable @Override public class_1296 method_5613(class_3218 world, class_1296 mate) { return null; }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar reg) {
        reg.add(new AnimationController<>(this, "controller", 0, this::predicate));
    }
    private PlayState predicate(software.bernie.geckolib.animation.AnimationState<LoveEntity> s) {
        s.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }
    @Override public AnimatableInstanceCache getAnimatableInstanceCache() { return cache; }

    @Override
    public void method_36209() {
        if (this.method_37908().field_9236) freeLight();
        super.method_36209();
    }
    @Override
    public void method_5650(class_5529 reason) {
        if (this.method_37908().field_9236) freeLight();
        super.method_5650(reason);
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        if (ownerUuid != null) nbt.method_25927("Owner", ownerUuid);
        nbt.method_10569("SpawnAge", spawnAge);
        nbt.method_10569("MaxLife", maxLifeTicks);
        nbt.method_10549("HitboxSize", hitboxSize);
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        ownerUuid = nbt.method_25928("Owner") ? nbt.method_25926("Owner") : null;
        spawnAge = nbt.method_10550("SpawnAge");
        maxLifeTicks = nbt.method_10550("MaxLife");
        hitboxSize = nbt.method_10545("HitboxSize") ? nbt.method_10574("HitboxSize") : hitboxSize;
    }
}
