package net.kronoz.odyssey.entity.thrasher;

import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.kronoz.odyssey.net.RollAttackC2SPayload;
import net.kronoz.odyssey.net.SliceAttackC2SPayload;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import java.util.*;

public final class RollAttackHandler {

    // Tracks heat per player
    private static final Map<UUID, PlayerHeat> PLAYER_HEAT = new HashMap<>();
    private static final List<SliceWave> ACTIVE_WAVES = new ArrayList<>();

    // Heat parameters
    private static final float BASE_INCREMENT = 1f;      // Heat added per slice at cold
    private static final float SCALING_FACTOR = 0.3f;    // Additional heat when already hot
    private static final float DECAY_RATE = 0.05f;       // Heat decay per tick
    private static final float OVERHEAT_THRESHOLD_BASE = 8f; // Base threshold
    private static final float THRESHOLD_RECOVERY = 0.01f;  // Threshold recovery per tick
    private static final float MIN_RESIDUAL_HEAT = 1f;      // Heat floor to prevent instant reset

    private static class PlayerHeat {
        float currentHeat = 0f;
        float overheatThreshold = OVERHEAT_THRESHOLD_BASE;
        boolean overheated = false;
        long lastClickTick = 0;
    }

    public static void onRollPacket(class_3222 player, RollAttackC2SPayload payload) {
        if (player.method_5854() == null) return; // must be riding

        class_3218 world = (class_3218) player.method_37908();
        class_243 direction = player.method_5828(1.0f);

        tryStartRoll(world, player, direction);
    }

    private static void tryStartRoll(class_3218 world, class_1657 player, class_243 direction) {
        class_1297 ridden = player.method_5854();
        if (ridden instanceof ThrasherEntity thrasher) {
            thrasher.triggerRollAnimation();
            thrasher.syncAnimationToClients();

            player.method_43496(class_2561.method_43470("worked"));
            if (thrasher.isRolling()) {
                if (thrasher.method_5996(class_5134.field_23719) != null) {
                    thrasher.method_5996(class_5134.field_23719)
                            .method_6192(6); // faster
                }
            }
            else if (thrasher.method_5996(class_5134.field_23719) != null) {
                thrasher.method_5996(class_5134.field_23719)
                        .method_6192(0.3); // back to normal
            }

        }

    }
}
