package net.kronoz.odyssey.entity.thrasher;



import net.kronoz.odyssey.init.ModParticles;
import net.kronoz.odyssey.init.ModSounds;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3959;
import java.util.*;

public final class SliceWave {
    private final class_3218 world;
    private final UUID ownerId;
    private final class_243 origin;
    private final class_243 direction;
    private final double speed;
    private final double range;
    private final double hitRadius;
    private final float damage;
    private final double push;
    private final double lift;

    private int age = 0;
    private double distanceTravelled = 0.0;
    private final Set<Integer> hitEntities = new HashSet<>();
    float minRandom = 1.3f;
    float maxRandom = 2.0f;

    Random random = new Random();

    float pitch = minRandom + random.nextFloat() * (maxRandom - minRandom);

    public SliceWave(class_3218 world, class_1657 owner, class_243 origin, class_243 direction) {
        this.world = world;
        this.ownerId = owner.method_5667();
        this.origin = origin;
        this.direction = direction.method_1029();
        this.speed = 1.5;          // blocks per tick
        this.range = 6;          // max distance
        this.hitRadius = 3.0;      // AoE radius
        this.damage = 6f;          // direct damage
        this.push = 1.5;           // horizontal knockback
        this.lift = 0.5;           // vertical knockback
    }

    public static SliceWave start(class_3218 world, class_1657 owner, class_243 direction) {
        return new SliceWave(world, owner, owner.method_33571(), direction);
    }

    public boolean tick() {
        class_1657 owner = world.method_18470(ownerId);
        if (owner == null || owner.method_31481()) return false;

        distanceTravelled = Math.min(distanceTravelled + speed, range);
        class_243 from = origin.method_1019(direction.method_1021(distanceTravelled - speed));
        class_243 to = origin.method_1019(direction.method_1021(distanceTravelled));

        // Spawn particles along the path


        // Check for block collisions
        class_3959 ctx = new class_3959(from, to, class_3959.class_3960.field_17558,
                class_3959.class_242.field_1348, owner);
        class_239 hit = world.method_17742(ctx);
        if (hit.method_17783() == class_239.class_240.field_1332) {
            applyAoE(owner, hit.method_17784());
            return false;
        }

        // Apply damage along the path
        applyAoE(owner, to);

        age++;
        return distanceTravelled < range;
    }

//    private void spawnParticles(Vec3d from, Vec3d to) {
//        int steps = (int)Math.ceil(from.distanceTo(to) * 2);
//        for (int i = 0; i <= steps; i++) {
//            Vec3d pos = from.lerp(to, i / (double) steps);
//            Vec3d eye = this.getEyePos();
//            Vec3d look = this.getRotationVec(1.0f);
//            world.spawnParticles(ModParticles.SLICE_PARTICLE, pos.x, pos.y, pos.z,
//                    1, 0.0, 0.0, 0.0, 0.0);
//        }
//    }

    private void applyAoE(class_1657 owner, class_243 center) {
        class_238 box = new class_238(center.field_1352 - hitRadius, center.field_1351 - hitRadius, center.field_1350 - hitRadius,
                center.field_1352 + hitRadius, center.field_1351 + hitRadius, center.field_1350 + hitRadius);




                class_243 eye = owner.method_33571();
                class_243 look = owner.method_5828(1.0f);
                world.method_14199(ModParticles.SLICE_PARTICLE, eye.field_1352 + look.field_1352 * 6,
                        eye.field_1351 + 0.1 + look.field_1351 * 6,
                        eye.field_1350 + look.field_1350 * 6,
                        1, 0.0, 0.0, 0.0, 0.0);
        world.method_8396(null, class_2338.method_49638(owner.method_19538()),
                ModSounds.SLICE, class_3419.field_15248, 0.8f, pitch);



        List<class_1297> targets = world.method_8333(owner, box, e -> e.method_5805()  &&
                !e.method_7325() &&
                e != owner &&
                e != owner.method_5854());

        for (class_1297 e : targets) {
            if (!hitEntities.add(e.method_5628())) continue; // only hit once
            e.method_5762(direction.field_1352 * push, lift, direction.field_1350 * push);
            e.field_6037 = true;

            System.out.println(owner.method_5854());

            if (e instanceof class_1309 le) {
                le.field_6008 = 0;
                le.method_5643(world.method_48963().method_48802(owner), damage);
            }
            world.method_14199(ModParticles.SLICE_PARTICLE, e.method_23317(),
                    e.method_23318() + 1.0,
                    e.method_23321(),
                    1, 0.0, 0.0, 0.0, 0.0);

            world.method_8396(null, class_2338.method_49638(e.method_19538()),
                    ModSounds.SLICE, class_3419.field_15248, 0.8f, pitch);
        }
    }
}
