package net.kronoz.odyssey.entity.thrasher;

import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1335;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.entity.*;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animation.*;
import software.bernie.geckolib.cache.object.GeoBone;

public class ThrasherEntity extends class_1314 implements GeoEntity {
    protected float jumpStrength = 10;
    protected boolean inAir;
    private boolean slicing = false;
    private boolean rolling = false;
    private int sliceAnimationTicks = 0;
    private int rollAnimationTicks = 0;
    private float seatOffset = 0f;
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache(this);

    public float spinSpeed = 0f;
    public float spinAngle = 0f;

    private float movespeed = 20f;

  // normal speed

    public ThrasherEntity(class_1299<? extends class_1314> type, class_1937 world) {
        super(type, world);
        this.field_6207 = new class_1335(this);
        this.field_6194 = 0;
        if (this.method_5996(class_5134.field_23719) != null) {
            this.method_5996(class_5134.field_23719)
                    .method_6192(0.3);
        }
    }

    public void method_5982() {
        if (this.method_37908().method_8407() == class_1267.field_5801 && this.method_23734()) {
            this.method_31472();
        } else {
            this.field_6278 = 0;
        }
    }

    @Nullable
    public boolean isInAir() { return this.inAir; }
    public void setInAir(boolean inAir) { this.inAir = inAir; }

    public static class_5132.class_5133 createAttributes() {
        return class_1314.method_26828()
                .method_26868(class_5134.field_23716, 40.0)
                .method_26868(class_5134.field_23719, 1)
                .method_26868(class_5134.field_23721, 7.0)
                .method_26868(class_5134.field_23717, 40.0)
                .method_26868(class_5134.field_23724, 6.0)
                .method_26868(class_5134.field_23718, 10.0)
                .method_26868(class_5134.field_47761, 1.0f);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar reg) {
        reg.add(new AnimationController<>(this, "controller", 2, this::predicate));
    }
    public boolean isSlicing() {
        return this.slicing;
    }
    boolean isRolling() {
        return this.rolling;
    }



    @Override
    public void method_5773() {
        super.method_5773();
        if (slicing) {
            sliceAnimationTicks++;
            if (sliceAnimationTicks > 9) {
                slicing = false;
                sliceAnimationTicks = 0;
            }
        }

    }

    public void triggerRollAnimation() {

        this.rollAnimationTicks = 1000;

    }

    public void triggerSliceAnimation() {
        this.slicing = true;
        this.sliceAnimationTicks = 0;
    }

    private boolean rollingAnimStarted = false;

    private PlayState predicate(AnimationState<ThrasherEntity> state) {
        if (rolling) {
            if (!rollingAnimStarted) {
                state.getController().setAnimation(
                        RawAnimation.begin().then("walk", Animation.LoopType.HOLD_ON_LAST_FRAME)
                );
                rollingAnimStarted = true;
                System.out.println("GUHH mung");
            }
            return PlayState.CONTINUE;
        } else {
            rollingAnimStarted = false; // reset when not rolling
        }

        if (slicing) {
            state.getController().setAnimation(
                    RawAnimation.begin().then("slice", Animation.LoopType.LOOP)
            );
            return PlayState.CONTINUE;
        }

        if (state.isMoving()) {
            state.getController().setAnimation(
                    RawAnimation.begin().then("walk", Animation.LoopType.LOOP)
            );
        } else {
            state.getController().setAnimation(
                    RawAnimation.begin().then("idle", Animation.LoopType.LOOP)
            );
        }

        return PlayState.CONTINUE;
    }

    public void syncAnimationToClients() {
        if (this.method_37908().field_9236) return;
        this.method_37908().method_8421(this, (byte) 67);
    }

    @Override
    public void method_5711(byte status) {
        if (status == 67) {
            this.triggerSliceAnimation();
        } else {
            super.method_5711(status);
        }
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() { return this.cache; }

    public void setJumpStrength(int strength) {
        this.field_6282 = true;
        this.jumpStrength = 0.4F + 0.4F * strength / 90.0F;
    }

    protected void putPlayerOnBack(class_1657 player) {
        if (!this.method_37908().field_9236) {
            player.method_36456(this.method_36454());
            player.method_36457(this.method_36455());
            player.method_5804(this);

        }
    }


    @Override
    public class_243 method_52538(class_1297 passenger) {
        class_243 base = this.method_19538();

        double forwardOffset = -0.2D;
        double sideOffset = 0.0D;
        double heightOffset = 1.5 + seatOffset * 0.5;

        float yawRad = (float) Math.toRadians(-this.method_36454());
        double x = base.field_1352 + forwardOffset * Math.sin(yawRad) + sideOffset * Math.cos(yawRad);
        double y = base.field_1351 + heightOffset;
        double z = base.field_1350 + forwardOffset * Math.cos(yawRad) - sideOffset * Math.sin(yawRad);

        return new class_243(x, y, z);
    }


    public void setSeatOffset(float offset) { this.seatOffset = offset; }
    public float getSeatOffset() { return this.seatOffset; }

    @Override
    public void method_6091(class_243 movementInput) {
        if (this.method_5782()) {
            class_1309 rider = (class_1309) this.method_31483();
            float targetYaw = rider.method_36454();
            float lerpedYaw = lerpYaw(this.method_36454(), targetYaw, 0.05f);
            this.method_36456(lerpedYaw);
            this.field_6283 = lerpedYaw;
            this.field_6241 = lerpedYaw;
            double speed = this.method_45325(class_5134.field_23719);
            double sideways = rider.field_6212 * 0.5 * speed;
            double forward = rider.field_6250 * speed;
            if (forward <= 0) forward *= 0.25;
            if (this.method_24828() && jumpStrength > 0) {
                this.jump(0.5f, new class_243(sideways, 0, forward));
            }
            class_243 look = rider.method_5828(1f);
            look = new class_243(rider.method_36454(), 0, rider.method_36454()).method_1029();
            super.method_6091(look.method_1021(speed));
        } else {
            super.method_6091(movementInput);
        }
    }

    protected void jump(float strength, class_243 movementInput) {
        class_243 vec3d = this.method_18798();
        this.method_18800(vec3d.field_1352, 0, vec3d.field_1350);
        this.setInAir(true);
        this.field_6007 = true;
        if (movementInput.field_1350 > 0.0F) {
            float f = class_3532.method_15374(this.method_36454() * ((float) Math.PI / 180F));
            float g = class_3532.method_15362(this.method_36454() * ((float) Math.PI / 180F));
            this.method_18799(this.method_18798().method_1031(-0.4F * f * strength, 0.0, 0.4F * g * strength));
        }
    }

    protected void method_49481(class_1657 controllingPlayer, class_243 movementInput) {
        super.method_49481(controllingPlayer, movementInput);
        class_241 vec2f = this.getControlledRotation(controllingPlayer);
        this.method_5710(vec2f.field_1342, vec2f.field_1343);
        this.field_5982 = this.field_6283 = this.field_6241 = this.method_36454();

        if (this.method_5787()) {
            if (this.method_24828()) {
                this.setInAir(false);
                if (this.jumpStrength > 0.0F && !this.isInAir()) {
                    this.jump(this.jumpStrength, movementInput);
                }
                this.jumpStrength = 0.0F;
            }
        }

        controllingPlayer.method_5768();
    }

    private float lerpYaw(float currentYaw, float targetYaw, float speed) {
        float delta = class_3532.method_15393(targetYaw - currentYaw);
        return currentYaw + delta * speed;
    }

    protected class_241 getControlledRotation(class_1309 controllingPassenger) {
        return new class_241(controllingPassenger.method_36455() * class_3532.method_16439(0.1f, 0.5f, 1f), controllingPassenger.method_36454());
    }

    protected class_243 method_49482(class_1657 controllingPlayer, class_243 movementInput) {
        if (this.method_24828() && this.jumpStrength == 0.0F && !this.field_6282) {
            return class_243.field_1353;
        }
        float f = controllingPlayer.field_6212 * 0.5F;
        float g = controllingPlayer.field_6250;
        controllingPlayer.method_5768();
        if (g <= 0.0F) g *= 0.25;
        return new class_243(f, 0, g);
    }

    protected float method_49485(class_1657 controllingPlayer) {
        return (float) this.method_45325(class_5134.field_23719);
    }

    @Override
    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (!this.method_5782() && !this.method_6109()) {
            this.putPlayerOnBack(player);
            return class_1269.method_29236(this.method_37908().field_9236);
        } else {
            return super.method_5992(player, hand);
        }
    }
}
