package net.kronoz.odyssey.entity.thrasher;

import net.kronoz.odyssey.Odyssey;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;

public class ThrasherModel extends GeoModel<ThrasherEntity> {
    @Override public class_2960 getModelResource(ThrasherEntity e){ return class_2960.method_60655(Odyssey.MODID,"geo/entity/thrasher.geo.json"); }
    @Override public class_2960 getTextureResource(ThrasherEntity e){ return class_2960.method_60655(Odyssey.MODID,"textures/entity/thrasher.png"); }
    @Override public class_2960 getAnimationResource(ThrasherEntity e){ return class_2960.method_60655(Odyssey.MODID,"animations/entity/thrasher.animation.json"); }

    @Override
    public void setCustomAnimations(ThrasherEntity e, long id, AnimationState<ThrasherEntity> s) {
        GeoBone head = getAnimationProcessor().getBone("head");
        GeoBone eye  = getAnimationProcessor().getBone("eye");

        GeoBone seatBone = getAnimationProcessor().getBone("seat");

        super.setCustomAnimations(e,id, s);
        GeoBone spinnerRight = this.getAnimationProcessor().getBone("rightaxe");
        GeoBone spinnerLeft = this.getAnimationProcessor().getBone("leftaxeb");
        if (spinnerLeft == null) return;
        if (spinnerRight == null) return;

        // Get velocity and movement direction
        class_243 velocity = e.method_18798();
        class_243 facing = e.method_5828(1.0f);

        e.setSeatOffset(seatBone.getPosY());

        // Dot product → how aligned velocity is with facing direction
        double forwardSpeed = velocity.method_1026(facing);

        // Magnitude of velocity → overall speed
        double totalSpeed = velocity.method_1033();

        // Compute spin speed and direction
        float spinSpeed = (float) (forwardSpeed * -800.0f); // tweak multiplier (higher = faster spin)

        // Smoothly interpolate spin progress (reduces jitter)
        e.spinSpeed += (spinSpeed - e.spinSpeed) * 0.2f;

        // Accumulate spin angle
        e.spinAngle += e.spinSpeed * 0.05f; // tweak multiplier to control smoothness

        // Keep angle within bounds (avoid float overflow)
        if (e.spinAngle > 360f || e.spinAngle < -360f) e.spinAngle = 0f;

        // Apply rotation to the bone (convert to radians)
        spinnerRight.setRotX((float) Math.toRadians(e.spinAngle));
        spinnerLeft.setRotX((float) Math.toRadians(e.spinAngle));



        var bladeBoneLeft = getAnimationProcessor().getBone("leftaxeb");
        var bladeBoneRight = getAnimationProcessor().getBone("rightaxeb");

        if (bladeBoneRight != null)
            bladeBoneRight.setHidden(!e.isSlicing());

        if (bladeBoneLeft != null)
            bladeBoneLeft.setHidden(!e.isSlicing());

    }



}
