package net.kronoz.odyssey.hud.death;

import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_9779;

public final class DeathUICutscene implements HudRenderCallback {
    private static boolean active = false;
    private static long startMs;
    private static boolean hudWasHidden = false;
    private static boolean savedHudHidden = false;

    private static final int FRAME_COUNT = 21;
    private static final class_2960[] FRAMES = new class_2960[FRAME_COUNT];

    private static final float FADE_WHITE_IN = 2.0f;
    private static final float A_LOOP_DURATION = 3.0f;
    private static final float A_LOOP_PERIOD = 0.08f;
    private static final float TO_BLACK = 1.2f;
    private static final float TO_WHITE = 1.2f;
    private static final float FRAME_DURATION = 0.10f;

    private static float time() { return (class_156.method_658() - startMs) / 1000.0f; }

    private static float tW1() { return FADE_WHITE_IN; }
    private static float tA0() { return tW1(); }
    private static float tA1() { return tA0() + A_LOOP_DURATION; }
    private static float tBLK1() { return tA1() + TO_BLACK; }
    private static float tW2() { return tBLK1() + TO_WHITE; }
    private static float tSEQ() { return tW2() + 18 * FRAME_DURATION; }

    static {
        for (int i = 0; i < FRAME_COUNT; i++) {
            FRAMES[i] = class_2960.method_60655("odyssey", "textures/gui/death/ui_of_death" + i + ".png");
        }
    }

    private DeathUICutscene() {}

    public static void register() {
        HudRenderCallback.EVENT.register(new DeathUICutscene());
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (!active) return;
            if (client.field_1690 != null) client.field_1690.field_1842 = true;
            if (client.field_1755 != null) client.method_1507(null);
        });
    }

    public static void start() {
        active = true;
        startMs = class_156.method_658();
        var mc = class_310.method_1551();
        if (mc != null && mc.field_1690 != null) {
            if (!savedHudHidden) {
                hudWasHidden = mc.field_1690.field_1842;
                savedHudHidden = true;
            }
            mc.field_1690.field_1842 = true;
            if (mc.field_1755 != null) mc.method_1507(null);
        }
    }

    private static void finish() {
        active = false;
        var mc = class_310.method_1551();
        if (mc != null && mc.field_1690 != null && savedHudHidden) mc.field_1690.field_1842 = hudWasHidden;
        savedHudHidden = false;
        if (mc != null && mc.field_1755 != null) mc.method_1507(null);
    }

    public static boolean isActive() { return active; }

    @Override
    public void onHudRender(class_332 ctx, class_9779 renderTickCounter) {
        if (!active) return;

        final float t = time();
        final int sw = ctx.method_51421();
        final int sh = ctx.method_51443();

        if (t <= tW1()) {
            float a = ease(t / FADE_WHITE_IN);
            ctx.method_25294(0, 0, sw, sh, ((int)(a * 255f) << 24) | 0xFFFFFF);
        } else if (t <= tA1()) {
            ctx.method_25294(0, 0, sw, sh, 0xFFFFFFFF);
            float loopT = t - tA0();
            int toggles = (int)Math.floor(loopT / A_LOOP_PERIOD);
            int frame = (toggles % 2 == 0) ? 18 : 19;
            drawCentered(ctx, FRAMES[frame], sw, sh, 0.2f);
        } else if (t <= tBLK1()) {
            ctx.method_25294(0, 0, sw, sh, 0xFFFFFFFF);
            float a = ease((t - tA1()) / TO_BLACK);
            ctx.method_25294(0, 0, sw, sh, ((int)(a * 255f) << 24));
        } else if (t <= tW2()) {
            ctx.method_25294(0, 0, sw, sh, 0xFF000000);
            float a = ease((t - tBLK1()) / TO_WHITE);
            ctx.method_25294(0, 0, sw, sh, ((int)(a * 255f) << 24) | 0xFFFFFF);
        } else if (t <= tSEQ()) {
            ctx.method_25294(0, 0, sw, sh, 0xFFFFFFFF);
            float local = t - tW2();
            int idx = class_3532.method_15340((int)Math.floor(local / FRAME_DURATION), 0, 17);
            drawCentered(ctx, FRAMES[idx], sw, sh, 0.2f);
        } else {
            finish();
        }
    }

    private static void drawCentered(class_332 ctx, class_2960 tex, int sw, int sh, float baseScale) {
        final int SRC_W = 256, SRC_H = 80;
        final float aspect = (float) SRC_W / SRC_H;
        float base = baseScale * Math.min(sw, sh);
        float desiredH = base;
        float desiredW = base * aspect;
        if (desiredW > sw * 0.75f) {
            desiredW = sw * 0.75f;
            desiredH = desiredW / aspect;
        }
        if (desiredH > sh * 0.75f) {
            desiredH = sh * 0.75f;
            desiredW = desiredH * aspect;
        }
        int scaleByH = Math.max(1, (int)Math.floor(desiredH / SRC_H));
        int scaleByW = Math.max(1, (int)Math.floor(desiredW / SRC_W));
        int scale = Math.max(1, Math.min(scaleByH, scaleByW));
        int fw = SRC_W * scale;
        int fh = SRC_H * scale;
        int x = (sw - fw) / 2;
        int y = (sh - fh) / 2;
        ctx.method_25290(tex, x, y, 0f, 0f, fw, fh, fw, fh);
    }

    private static float ease(float x) {
        x = class_3532.method_15363(x, 0f, 1f);
        return x * x * (3f - 2f * x);
    }
}
