package net.kronoz.odyssey.init;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.kronoz.odyssey.hud.death.DeathUICutscene;
import net.kronoz.odyssey.systems.data.BodyPartRegistry;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import java.util.List;

import static net.fabricmc.fabric.api.client.command.v2.ClientCommandManager.argument;
import static net.fabricmc.fabric.api.client.command.v2.ClientCommandManager.literal;

public final class ModCommands {
    public static void init() {
        net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, env) -> register(dispatcher));
    }
    private static final List<String> EASINGS = List.of(
            "linear",
            "quad_in", "quad_out",
            "cubic_inout", "smoothstep",
            "sine_in", "sine_out",
            "expo_in", "expo_out",
            "back_inout",
            "bounce_out"
    );

    private static final SuggestionProvider<?> EASING_SUGGESTIONS =
            (context, builder) -> {
                for (String e : EASINGS) builder.suggest(e);
                return builder.buildFuture();
            };

    private static void register(CommandDispatcher<class_2168> d) {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
            dispatcher.register(literal("csrec")
                    .then(literal("origin")
                            .then(literal("set").executes(ctx -> {
                                net.kronoz.odyssey.client.cs.CutsceneRecorder.I.setOriginFromPlayer();
                                ctx.getSource().sendFeedback(class_2561.method_43470("Origin set (player position & rotation)."));
                                return 1;
                            }))
                    )
                    .then(literal("key")
                            .then(literal("add")
                                    .then(argument("duration", DoubleArgumentType.doubleArg(0.0))
                                            .executes(ctx -> {
                                                double dur = DoubleArgumentType.getDouble(ctx, "duration");
                                                net.kronoz.odyssey.client.cs.CutsceneRecorder.I.addKey(dur, "linear", "linear");
                                                ctx.getSource().sendFeedback(class_2561.method_43470("Keyframe added (duration=" + dur + "s, easePos=linear, easeRot=linear)."));
                                                return 1;
                                            })
                                            .then(argument("easePos", StringArgumentType.word())
                                                    .executes(ctx -> {
                                                        double dur = DoubleArgumentType.getDouble(ctx, "duration");
                                                        String ep = StringArgumentType.getString(ctx, "easePos");
                                                        net.kronoz.odyssey.client.cs.CutsceneRecorder.I.addKey(dur, ep, "linear");
                                                        ctx.getSource().sendFeedback(class_2561.method_43470("Keyframe added (duration=" + dur + "s, easePos=" + ep + ", easeRot=linear)."));
                                                        return 1;
                                                    })
                                                    .then(argument("easeRot", StringArgumentType.word())
                                                            .executes(ctx -> {
                                                                double dur = DoubleArgumentType.getDouble(ctx, "duration");
                                                                String ep = StringArgumentType.getString(ctx, "easePos");
                                                                String er = StringArgumentType.getString(ctx, "easeRot");
                                                                net.kronoz.odyssey.client.cs.CutsceneRecorder.I.addKey(dur, ep, er);
                                                                ctx.getSource().sendFeedback(class_2561.method_43470("Keyframe added (duration=" + dur + "s, easePos=" + ep + ", easeRot=" + er + ")."));
                                                                return 1;
                                                            })
                                                    )
                                            )
                                    )
                            )
                    )
                    .then(literal("list").executes(ctx -> {
                        var list = net.kronoz.odyssey.client.cs.CutsceneRecorder.I.list();
                        if (list.isEmpty()) {
                            ctx.getSource().sendFeedback(class_2561.method_43470("No keyframes."));
                        } else {
                            StringBuilder sb = new StringBuilder("Keyframes:\n");
                            for (int i = 0; i < list.size(); i++) {
                                var k = list.get(i);
                                sb.append("#").append(i)
                                        .append(" dur=").append(k.duration)
                                        .append(" pos=(").append(String.format("%.3f,%.3f,%.3f", k.rx,k.ry,k.rz)).append(")")
                                        .append(" rot=(").append(String.format("%.1f,%.1f", k.yaw,k.pitch)).append(")")
                                        .append(" easePos=").append(k.easePos)
                                        .append(" easeRot=").append(k.easeRot)
                                        .append("\n");
                            }
                            ctx.getSource().sendFeedback(class_2561.method_43470(sb.toString()));
                        }
                        return 1;
                    }))
                    .then(literal("clear").executes(ctx -> {
                        net.kronoz.odyssey.client.cs.CutsceneRecorder.I.clear();
                        ctx.getSource().sendFeedback(class_2561.method_43470("Recorder cleared."));
                        return 1;
                    }))
                    .then(literal("export")
                            .then(argument("name", StringArgumentType.word())
                                    .executes(ctx -> {
                                        String name = StringArgumentType.getString(ctx, "name");
                                        try {
                                            var path = net.kronoz.odyssey.client.cs.CutsceneRecorder.I.exportJson(name);
                                            ctx.getSource().sendFeedback(class_2561.method_43470("Exported to: " + path));
                                            return 1;
                                        } catch (Exception e) {
                                            ctx.getSource().sendError(class_2561.method_43470("Export failed: " + e.getMessage()));
                                            return 0;
                                        }
                                    })
                            )
                    )
                    .then(literal("play").executes(ctx -> {
                        net.kronoz.odyssey.client.cs.CutsceneRecorder.I.startPreview();
                        ctx.getSource().sendFeedback(class_2561.method_43470("Preview started."));
                        return 1;
                    }))
            );
        });
        d.register(class_2170.method_9247("bodymod")
                .requires(src -> src.method_9259(2))
                .then(class_2170.method_9247("set")
                        .then(class_2170.method_9244("slot", StringArgumentType.string())
                                .then(class_2170.method_9244("id", net.minecraft.class_2232.method_9441())
                                        .suggests((c,b)-> class_2172.method_9270(BodyPartRegistry.all().keySet(), b))
                                        .executes(ctx -> {
                                            var p = ctx.getSource().method_44023();
                                            String slot = StringArgumentType.getString(ctx, "slot");
                                            class_2960 id = net.minecraft.class_2232.method_9443(ctx, "id");
                                            var def = BodyPartRegistry.get(id);
                                            if (def == null) return 0;
                                            ModComponents.BODY.get(p).setPart(slot, id);
                                            ModComponents.BODY.get(p).sync(p);
                                            return 1;
                                        }))))
                .then(class_2170.method_9247("clear")
                        .then(class_2170.method_9244("slot", StringArgumentType.string())
                                .executes(ctx -> {
                                    var p = ctx.getSource().method_44023();
                                    String slot = StringArgumentType.getString(ctx, "slot");
                                    ModComponents.BODY.get(p).clearSlot(slot);
                                    ModComponents.BODY.get(p).sync(p);
                                    return 1;
                                })))
        );
        d.register(class_2170.method_9247("deathui")
              .executes(ctx -> {
                      DeathUICutscene.start();
                      return 1;
             })
        );
    }
}
