package net.kronoz.odyssey.init;

import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.kronoz.odyssey.Odyssey;
import net.kronoz.odyssey.entity.*;
import net.kronoz.odyssey.entity.apostasy.ApostasyEntity;
import net.kronoz.odyssey.entity.arcangel.ArcangelEntity;
import net.kronoz.odyssey.entity.projectile.LaserProjectileEntity;
import net.kronoz.odyssey.entity.sentinel.SentinelEntity;
import net.kronoz.odyssey.entity.sentry.SentryEntity;
import net.kronoz.odyssey.entity.souls.LoveEntity;
import net.kronoz.odyssey.entity.thrasher.ThrasherEntity;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_4048;
import net.minecraft.class_7923;

public class ModEntities {
    public static class_1299<LiftPlatformEntity> LIFT_PLATFORM;
    public static class_1299<LiftPartColliderEntity> LIFT_PART_COLLIDER;
    public static class_1299<SlidePlatformEntity> SLIDE_PLATFORM;
    public static class_1299<SlidePartColliderEntity> SLIDE_PART_COLLIDER;
    public static final class_1299<SentinelEntity> SENTINEL = class_2378.method_10230(
            class_7923.field_41177,
            class_2960.method_60655(Odyssey.MODID, "sentinel"),
            class_1299.class_1300.<SentinelEntity>method_5903(SentinelEntity::new, class_1311.field_6302)
                    .method_17687(0.8f, 0.8f)
                    .method_55687(0.6f)
                    .build()
    );
    public static final class_1299<SentryEntity> SENTRY = class_2378.method_10230(
            class_7923.field_41177,
            class_2960.method_60655(Odyssey.MODID, "sentry"),
            class_1299.class_1300.<SentryEntity>method_5903(SentryEntity::new, class_1311.field_6302)
                    .method_17687(0.9f, 2.95f)
                    .build()
    );
    public static final class_1299<ArcangelEntity> ARCANGEL =
            FabricEntityTypeBuilder.<ArcangelEntity>create(class_1311.field_17715, ArcangelEntity::new)
                    .dimensions(class_4048.method_18385(1.8f, 3.0f))
                    .trackRangeChunks(12)
                    .fireImmune()
                    .build();
    public static final class_1299<ApostasyEntity> APOSTASY = class_2378.method_10230(
            class_7923.field_41177,
            class_2960.method_60655(Odyssey.MODID, "apostasy"),
            class_1299.class_1300.<ApostasyEntity>method_5903(ApostasyEntity::new, class_1311.field_6302)
                    .method_17687(3.0f, 5.0f)
                    .build()
    ); public static final class_1299<ThrasherEntity> THRASHER = class_2378.method_10230(
            class_7923.field_41177,
            class_2960.method_60655(Odyssey.MODID, "thrasher"),
            class_1299.class_1300.<ThrasherEntity>method_5903(ThrasherEntity::new, class_1311.field_6302)
                    .method_17687(3.0f, 5.0f)
                    .build());

    public static final class_1299<LoveEntity> LOVE = class_2378.method_10230(
            class_7923.field_41177,
            class_2960.method_60655(Odyssey.MODID, "love"),
            class_1299.class_1300.<LoveEntity>method_5903(LoveEntity::new, class_1311.field_6303)
                    .method_17687(3.0f, 5.0f)
                    .build()
    );
    public static final class_1299<LaserProjectileEntity> LASER_PROJECTILE =
            class_2378.method_10230(class_7923.field_41177, class_2960.method_60655("odyssey","laser_projectile"),
                    FabricEntityTypeBuilder.<LaserProjectileEntity>create(class_1311.field_17715, LaserProjectileEntity::new)
                            .dimensions(class_4048.method_18385(0.2f, 0.2f)).trackRangeBlocks(96).trackedUpdateRate(10).build());
    public static final class_1299<GroundDecalEntity> GROUND_DECAL = class_2378.method_10230(
    class_7923.field_41177,
            class_2960.method_60655("odyssey","ground_marker"),
    class_1299.class_1300.<GroundDecalEntity>method_5903(GroundDecalEntity::new, class_1311.field_17715)
        .method_17687(0.0f, 0.0f)
        .method_27299(128)
        .method_27300(1)
        .build()
    );
    public static final class_1299<DebrisBlockEntity> DEBRIS_BLOCK = class_2378.method_10230(
            class_7923.field_41177,
            class_2960.method_60655("odyssey","debris_block"),
            class_1299.class_1300.<DebrisBlockEntity>method_5903(DebrisBlockEntity::new, class_1311.field_17715)
                    .method_17687(0.98f, 0.98f) // roughly a block
                    .method_27299(128)
                    .method_27300(1)
                    .build()
    );
    public static class_1299<ShockwaveEntity> SHOCKWAVE =
            class_2378.method_10230(class_7923.field_41177, class_2960.method_60655("odyssey","shockwave"),
                    class_1299.class_1300.method_5903(ShockwaveEntity::new, class_1311.field_17715)
                            .method_17687(0.1f, 0.1f).method_27299(128).method_27300(1).build()
            );


    public static void init() {
        FabricDefaultAttributeRegistry.register(APOSTASY, ApostasyEntity.createAttributes());
        FabricDefaultAttributeRegistry.register(SENTRY, SentryEntity.createAttributes());
        FabricDefaultAttributeRegistry.register(SENTINEL, SentinelEntity.createAttributes());
        FabricDefaultAttributeRegistry.register(ARCANGEL, ArcangelEntity.createAttributes());
        FabricDefaultAttributeRegistry.register(THRASHER, ThrasherEntity.createAttributes());
        FabricDefaultAttributeRegistry.register(LOVE, LoveEntity.createAttributes());

    }
    public static void register() {
        LIFT_PLATFORM = class_2378.method_10230(
                class_7923.field_41177,
                class_2960.method_60655(Odyssey.MODID, "lift_platform"),
                class_1299.class_1300.method_5903(LiftPlatformEntity::new, class_1311.field_17715)
                        .method_17687(0.95f, 0.85f)
                        .method_27299(128)
                        .build()
        );
        LIFT_PART_COLLIDER = class_2378.method_10230(
                class_7923.field_41177,
                class_2960.method_60655(Odyssey.MODID, "lift_part_collider"),
                class_1299.class_1300.<LiftPartColliderEntity>method_5903(LiftPartColliderEntity::new, class_1311.field_17715)
                        .method_17687(1.0f, 1.0f)
                        .method_27299(64)
                        .build()
        );

        SLIDE_PLATFORM = class_2378.method_10230(
                class_7923.field_41177,
                class_2960.method_60655(Odyssey.MODID,"slide_platform"),
                class_1299.class_1300.method_5903(
                        SlidePlatformEntity::new, class_1311.field_17715
                ).method_17687(1.0f,1.0f).method_27299(128).build()
        );
        SLIDE_PART_COLLIDER = class_2378.method_10230(
                class_7923.field_41177,
                class_2960.method_60655(Odyssey.MODID,"slide_part_collider"),
                class_1299.class_1300.method_5903(
                        SlidePartColliderEntity::new, class_1311.field_17715
                ).method_17687(1.0f,1.0f).method_27299(64).build()
        );
    }
}
