package net.kronoz.odyssey.init;

import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.kronoz.odyssey.movement.MovementVisuals;
import net.kronoz.odyssey.net.DashC2SPayload;
import net.kronoz.odyssey.net.SliceAttackC2SPayload;
import net.minecraft.class_243;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import org.lwjgl.glfw.GLFW;

public final class ModKeybinds {
    private static class_304 DASH;
    private static class_304 SLICE;
    private static long lastPressMs = 0;

    public static void init() {
        DASH = KeyBindingHelper.registerKeyBinding(new class_304(
                "key.odyssey.dash",
                class_3675.class_307.field_1668,
                GLFW.GLFW_KEY_R,
                "key.categories.movement"
        ));


        SLICE = KeyBindingHelper.registerKeyBinding(new class_304(
                "key.odyssey.slice",
                class_3675.class_307.field_1668,
                GLFW.GLFW_KEY_Y,
                "key.categories.gameplay"
        ));

        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            var p = client.field_1724;
            MovementVisuals.clientTick(p);

            while (DASH.method_1436()) {
                long now = System.currentTimeMillis();
                if (now - lastPressMs < 120) continue;
                lastPressMs = now;
                if (p == null) continue;

                var opts = class_310.method_1551().field_1690;
                boolean f = opts.field_1894.method_1434();
                boolean b = opts.field_1881.method_1434();
                boolean l = opts.field_1913.method_1434();
                boolean r = opts.field_1849.method_1434();
                boolean up = opts.field_1903.method_1434();
                boolean dn = opts.field_1832.method_1434();

                class_243 look = p.method_5828(1.0f).method_1029();
                class_243 fwdFlat = new class_243(look.field_1352, 0, look.field_1350);
                if (fwdFlat.method_1027() < 1e-6) fwdFlat = new class_243(0, 0, 1);
                fwdFlat = fwdFlat.method_1029();
                class_243 right = new class_243(fwdFlat.field_1350, 0, -fwdFlat.field_1352);

                double ax = (r ? 1 : 0) - (l ? 1 : 0);
                double az = (f ? 1 : 0) - (b ? 1 : 0);
                double keyVy = (up ? 1 : 0) - (dn ? 1 : 0);

                double pitchVy = class_3532.method_15350(look.field_1351, -1.0, 1.0);
                double vy = keyVy != 0 ? keyVy : pitchVy;

                class_243 horiz = fwdFlat.method_1021(az).method_1019(right.method_1021(ax));
                if (horiz.method_1027() < 1e-6) horiz = fwdFlat;
                horiz = horiz.method_1029();

                double hMag = Math.sqrt(Math.max(0.0, 1.0 - vy * vy));
                class_243 dir = new class_243(horiz.field_1352 * hMag, vy, horiz.field_1350 * hMag).method_1029();

                float spd = p.method_5624() ? 1.2f : 0.95f;
                float tinyUp = p.method_24828() ? 0.04f : 0.0f;

                ModNetworking.send(new DashC2SPayload((float)dir.field_1352, (float)dir.field_1351, (float)dir.field_1350, spd, tinyUp));
            }

            while (SLICE.method_1436()) {
                if (p != null) {
                    ModNetworking.send(new SliceAttackC2SPayload(1, 1, 1, 1));
                }
            }
        });
    }
}