// net/kronoz/odyssey/item/client/renderer/JetpackBoneCache.java
package net.kronoz.odyssey.item.client.renderer;

import org.joml.Quaternionf;
import org.joml.Vector3f;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_243;

public final class JetpackBoneCache {
    private JetpackBoneCache() {}

    public static final class Pose {
        public class_243 pos;
        public Quaternionf rot;
        public Vector3f right, up, fwd;
        public long lastSeenNanos;
    }

    private static final Map<String, Pose> POSES = new ConcurrentHashMap<>();

    public static void set(String name, class_243 p, Quaternionf q, Vector3f right, Vector3f up, Vector3f fwd) {
        Pose pose = new Pose();
        pose.pos = p; pose.rot = q; pose.right = right; pose.up = up; pose.fwd = fwd;
        pose.lastSeenNanos = System.nanoTime();
        POSES.put(name, pose);
    }

    public static Pose get(String name) { return POSES.get(name); }
    public static Map<String, Pose> all() { return POSES; }
}
