package net.kronoz.odyssey.item.client.renderer;

import net.kronoz.odyssey.Odyssey;
import net.kronoz.odyssey.item.custom.JetpackTorso;
import net.kronoz.odyssey.systems.physics.jetpack.JetpackExhaustManager;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.joml.Matrix4f;
import org.joml.Vector4f;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.DefaultedItemGeoModel;
import software.bernie.geckolib.renderer.specialty.DynamicGeoItemRenderer;

import java.util.Set;

public class JetpackRenderer extends DynamicGeoItemRenderer<JetpackTorso> {
    private static final class_2960 MODEL_ID = class_2960.method_60655(Odyssey.MODID, "jetpack");
    private static final Set<String> BOOSTERS = Set.of("booster_1","booster_2","booster_3");

    public JetpackRenderer() {
        super(new DefaultedItemGeoModel<>(MODEL_ID));
    }

    @Override
    protected boolean boneRenderOverride(
            class_4587 ms,
            GeoBone bone,
            class_4597 buffers,
            class_4588 buffer,
            float pt,
            int packedLight,
            int packedOverlay,
            int colour
    ) {
        if (!BOOSTERS.contains(bone.getName())) return false;

        class_1799 stack = this.getCurrentItemStack();
        if (stack == null || stack.method_7960()) return false;

        Matrix4f m = ms.method_23760().method_23761();
        class_243 originWS = toWorld(bone, m);

        // derive a stable context id from the camera entity if present
        String ownerId = "nocam";
        var mc = class_310.method_1551();
        if (mc != null && mc.method_1560() != null) {
            ownerId = mc.method_1560().method_5845();
        }

        // per-stack identity + bone name => 3 distinct emitters
        String stackId = Integer.toHexString(System.identityHashCode(stack));
        String key = ownerId + ":" + stackId + ":" + bone.getName();

        JetpackExhaustManager.emit(key, originWS);
        return false;
    }

    private static class_243 toWorld(GeoBone bone, Matrix4f m) {
        float lx = bone.getPosX() / 16f;
        float ly = bone.getPosY() / 16f;
        float lz = bone.getPosZ() / 16f;
        Vector4f v = new Vector4f(lx, ly, lz, 1f).mul(m);
        class_243 cam = class_310.method_1551().field_1773.method_19418().method_19326();
        return new class_243(cam.field_1352 + v.x, cam.field_1351 + v.y, cam.field_1350 + v.z);
    }
}
