package net.kronoz.odyssey.item.client.renderer;

import net.kronoz.odyssey.Odyssey;
import net.kronoz.odyssey.item.custom.TomahawkItem;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.cache.object.GeoCube;
import software.bernie.geckolib.model.DefaultedItemGeoModel;
import software.bernie.geckolib.renderer.specialty.DynamicGeoItemRenderer;
import software.bernie.geckolib.util.Color;

public class TomahawkRenderer extends DynamicGeoItemRenderer<TomahawkItem> {

    private static final class_2960 MODEL_ID   = class_2960.method_60655(Odyssey.MODID, "tomahawk");
    private static final String     BONE_NAME  = "cloth_0";

    private static final boolean DEBUG_DRAW_BONE = false;
    private static final class_2960 DEBUG_TEX    = class_2960.method_60655(Odyssey.MODID, "textures/cloth/tomahawk_cloth.png");
    private static final class_1921 DEBUG_LAYER = class_1921.method_23580(DEBUG_TEX);
    private static final int FULL_LIGHT = 0x00F000F0;
    private static final int WHITE = Color.WHITE.getColor();

    public TomahawkRenderer() {
        super(new DefaultedItemGeoModel<>(MODEL_ID));
    }

    @Override
    protected boolean boneRenderOverride(
            class_4587 ms,
            GeoBone bone,
            class_4597 buffers,
            class_4588 buffer,
            float pt,
            int packedLight,
            int packedOverlay,
            int colour
    ) {
        if (bone.isHidden() || !BONE_NAME.equals(bone.getName())) return false;

        class_1799 current = this.getCurrentItemStack();
        if (!(current.method_7909() instanceof TomahawkItem)) return false;

        BonePose pose = computeBonePose(ms.method_23760().method_23761(), bone);

        class_310 mc = class_310.method_1551();

        if (DEBUG_DRAW_BONE) {
            class_4588 vc = buffers.getBuffer(DEBUG_LAYER);
            for (GeoCube cube : bone.getCubes()) {
                ms.method_22903();
                renderCube(ms, cube, vc, FULL_LIGHT, class_4608.field_21444, WHITE);
                ms.method_22909();
            }
            return true;
        }
        return false;
    }


    private static final class BonePose {
        class_243 worldPos;
        Quaternionf orientation;
        Vector3f rightWS, upWS, forwardWS;
    }

    private static BonePose computeBonePose(Matrix4f m, GeoBone bone) {
        float lx = bone.getPosX() / 16f;
        float ly = bone.getPosY() / 16f;
        float lz = bone.getPosZ() / 16f;

        org.joml.Vector4f v = new org.joml.Vector4f(lx, ly, lz, 1f).mul(m);

        Vector3f xCol = new Vector3f(m.m00(), m.m10(), m.m20()).normalize();
        Vector3f yCol = new Vector3f(m.m01(), m.m11(), m.m21()).normalize();
        Vector3f zCol = new Vector3f(m.m02(), m.m12(), m.m22()).normalize();

        org.joml.Matrix3f rot = new org.joml.Matrix3f(
                xCol.x, yCol.x, zCol.x,
                xCol.y, yCol.y, zCol.y,
                xCol.z, yCol.z, zCol.z
        );
        Quaternionf q = new Quaternionf().setFromNormalized(rot);

        class_243 cam = class_310.method_1551().field_1773.method_19418().method_19326();
        class_243 worldPos = new class_243(cam.field_1352 + v.x, cam.field_1351 + v.y, cam.field_1350 + v.z);

        BonePose out = new BonePose();
        out.worldPos = worldPos;
        out.orientation = q;
        out.rightWS = xCol;
        out.upWS = yCol;
        out.forwardWS = zCol;
        return out;
    }
}
