package net.kronoz.odyssey.mixin;

import net.kronoz.odyssey.systems.cam.ScreenShake;
import net.kronoz.odyssey.systems.cinematics.runtime.CameraOverrideController;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_4184.class)
public abstract class CameraMixin {

    @Shadow private float yaw;
    @Shadow private float pitch;
    @Shadow protected abstract void setRotation(float yaw, float pitch);
    @Shadow protected abstract void setPos(double x, double y, double z);
    @Shadow public abstract class_243 getPos();
    @Shadow public abstract float getYaw();
    @Shadow public abstract float getPitch();

    @Inject(method = "update", at = @At("TAIL"))
    private void odyssey$applyAdditiveFollow(class_1922 area, class_1297 focusedEntity, boolean thirdPerson, boolean inverseView, float tickDelta, CallbackInfo ci){
        CameraOverrideController ctrl = CameraOverrideController.I;
        if(!ctrl.active) return;

        class_243 basePos = this.getPos();
        float baseYaw = this.getYaw();
        float basePitch = this.getPitch();

        if(ctrl.mode == CameraOverrideController.Mode.ABSOLUTE){
            double x = ctrl.posX, y = ctrl.posY, z = ctrl.posZ;
            if(ctrl.lockX) x = basePos.field_1352;
            if(ctrl.lockY) y = basePos.field_1351;
            if(ctrl.lockZ) z = basePos.field_1350;

            this.setRotation(ctrl.yaw, ctrl.pitch);
            this.setPos(x, y, z);
            return;
        }

        class_243 local = new class_243(ctrl.offsetX, ctrl.offsetY, ctrl.offsetZ);

        float yawRad = (float) Math.toRadians(-baseYaw);
        double cosY = Math.cos(yawRad), sinY = Math.sin(yawRad);
        class_243 ry = new class_243(
                local.field_1352 * cosY - local.field_1350 * sinY,
                local.field_1351,
                local.field_1352 * sinY + local.field_1350 * cosY
        );

        float pitchRad = (float) Math.toRadians(basePitch);
        double cosX = Math.cos(pitchRad), sinX = Math.sin(pitchRad);
        class_243 rxy = new class_243(
                ry.field_1352,
                ry.field_1351 * cosX - ry.field_1350 * sinX,
                ry.field_1351 * sinX + ry.field_1350 * cosX
        );

        double fx = basePos.field_1352 + rxy.field_1352;
        double fy = basePos.field_1351 + rxy.field_1351;
        double fz = basePos.field_1350 + rxy.field_1350;

        if(ctrl.lockX) fx = basePos.field_1352;
        if(ctrl.lockY) fy = basePos.field_1351;
        if(ctrl.lockZ) fz = basePos.field_1350;

        float finalYaw = baseYaw + ctrl.yawOffset;
        float finalPitch = class_3532.method_15363(basePitch + ctrl.pitchOffset, -90f, 90f);

        this.setRotation(finalYaw, finalPitch);
        this.setPos(fx, fy, fz);
    }

    @Inject(method = "update(Lnet/minecraft/world/BlockView;Lnet/minecraft/entity/Entity;ZZF)V",
            at = @At("TAIL"))
    private void odyssey$afterUpdate(class_1922 area, class_1297 focusedEntity, boolean thirdPerson, boolean inverseView, float tickDelta, CallbackInfo ci) {
        ScreenShake.update();

        float shakeX = ScreenShake.getShakeX();
        float shakeY = ScreenShake.getShakeY();

        if (Math.abs(shakeX) < 1e-4f && Math.abs(shakeY) < 1e-4f) return;

        float cy = class_3532.method_15362((float) Math.toRadians(this.yaw));
        float sy = class_3532.method_15374((float) Math.toRadians(this.yaw));
        float cp = class_3532.method_15362((float) Math.toRadians(this.pitch));
        float sp = class_3532.method_15374((float) Math.toRadians(this.pitch));

        Vector3f right = new Vector3f(cy, 0, -sy).normalize();
        Vector3f up    = new Vector3f(-sy * sp, cp, -cy * sp).normalize();

        Vector3f delta = new Vector3f(right).mul(shakeX).add(new Vector3f(up).mul(shakeY));

        class_4184 self = (class_4184) (Object) this;
        CameraAccessor acc = (CameraAccessor) self;
        acc.odyssey$setPos(self.method_19326().field_1352 + delta.x, self.method_19326().field_1351 + delta.y, self.method_19326().field_1350 + delta.z);
    }
}
