// src/main/java/net/kronoz/odyssey/mixin/ClientPlayerEntityMixin.java
package net.kronoz.odyssey.mixin;

import net.kronoz.odyssey.OdysseyClient;
import net.kronoz.odyssey.client.bridge.WallRunAccess;
import net.kronoz.odyssey.movement.MovementVisuals;
import net.kronoz.odyssey.movement.WallRun;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_746.class)
public abstract class ClientPlayerEntityMixin implements WallRunAccess {
    @Unique private final WallRun.WallState odyssey$wall = new WallRun.WallState();

    @Inject(method = "tickMovement", at = @At("TAIL"))
    private void odyssey$clientWallRun(CallbackInfo ci) {
        class_746 self = (class_746)(Object)this;
        WallRun.tick(self, odyssey$wall);
        MovementVisuals.updateWallTilt(self, odyssey$wall);
        OdysseyClient.update(self, odyssey$wall);
    }

    public WallRun.WallState odyssey$getWallState() { return odyssey$wall; }
}
