package net.kronoz.odyssey.mixin;

import net.kronoz.odyssey.config.OdysseyConfig;
import net.kronoz.odyssey.systems.render.SlotItemResolver;
import net.minecraft.class_1268;
import net.minecraft.class_1306;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_742;
import net.minecraft.class_759;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import net.minecraft.class_811;
import net.minecraft.class_918;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_759.class)
public class HeldItemRendererMixin {

    @Inject(
            method = "renderFirstPersonItem(Lnet/minecraft/client/network/AbstractClientPlayerEntity;FFLnet/minecraft/util/Hand;FLnet/minecraft/item/ItemStack;FLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V",
            at = @At("HEAD"),
            cancellable = true
    )
    private void odyssey$renderFP(class_742 player, float tickDelta, float pitch,
                                  class_1268 hand, float swingProgress, class_1799 heldStack, float equipProgress,
                                  class_4587 matrices, class_4597 vcp, int light, CallbackInfo ci) {
        if (player == null) return;

        final class_1306 arm = (hand == class_1268.field_5808) ? player.method_6068() : player.method_6068().method_5928();
        final boolean left = (arm == class_1306.field_6182);
        final float side = left ? -1f : 1f;

        final class_2960 partItemId = SlotItemResolver.resolve(left ? "left_arm" : "right_arm", player);
        final boolean hasPart = partItemId != null && class_7923.field_41178.method_10250(partItemId);

        if (!hasPart) return;

        final float equip = 1.0f - equipProgress;
        final float swing = class_3532.method_15374(class_3532.method_15355(swingProgress) * (float) Math.PI);
        final float swingAmp = swing * Math.max(0f, OdysseyConfig.swingIntensity);
        final float equipAmp = equip * Math.max(0f, OdysseyConfig.equipIntensity);
        final float pitchNorm = class_3532.method_15363(pitch / 90f, -1f, 1f);

        final class_918 ir = class_310.method_1551().method_1480();

        matrices.method_22903();

        boolean drewHeldViaSocket = false;

        if (OdysseyConfig.renderArmOverlay) {
            class_1792 partItem = class_7923.field_41178.method_10223(partItemId);
            class_1799 partStack = new class_1799(partItem);

            matrices.method_22903();
            applyOverlayPose(matrices, side, swingAmp, equipAmp, pitchNorm);
            ir.method_23177(player, partStack,
                    left ? class_811.field_4321 : class_811.field_4322,
                    left, matrices, vcp, player.method_37908(), light, class_4608.field_21444, player.method_5628());
            matrices.method_22909();

            drewHeldViaSocket = true;
        }

        if (!drewHeldViaSocket && heldStack != null && !heldStack.method_7960()) {
            matrices.method_22903();
            applyHeldPose(matrices, side, swingAmp, equipAmp, pitchNorm);
            ir.method_23177(player, heldStack,
                    left ? class_811.field_4321 : class_811.field_4322,
                    left, matrices, vcp, player.method_37908(), light, class_4608.field_21444, player.method_5628());
            matrices.method_22909();
        }

        matrices.method_22909();
        ci.cancel();
    }

    private static void applyHeldPose(class_4587 m, float side, float swingAmp, float equipAmp, float pitchNorm) {
        final float PITCH_CLAMP = 0.35f;
        float limitedPitch = class_3532.method_15363(pitchNorm, -PITCH_CLAMP, PITCH_CLAMP);
        float pitchAbs = Math.abs(limitedPitch);

        float baseX = side * OdysseyConfig.heldBaseX
                + side * (OdysseyConfig.swingX * swingAmp + OdysseyConfig.equipX * equipAmp);
        float baseY = OdysseyConfig.heldBaseY
                + (OdysseyConfig.swingY * swingAmp + OdysseyConfig.equipY * equipAmp);
        float baseZ = OdysseyConfig.heldBaseZ
                + (OdysseyConfig.swingZ * swingAmp + OdysseyConfig.equipZ * equipAmp);
        m.method_46416(baseX, baseY, baseZ);

        m.method_22907(class_7833.field_40714.rotationDegrees(OdysseyConfig.heldRotX));
        m.method_22907(class_7833.field_40716.rotationDegrees(side * OdysseyConfig.heldRotY));
        m.method_22907(class_7833.field_40718.rotationDegrees(side * OdysseyConfig.heldRotZ));

        float localDX = side * OdysseyConfig.inwardXMax * pitchAbs;
        float localDY = -OdysseyConfig.dropYMax * (swingAmp + pitchAbs);
        float localDZ =  OdysseyConfig.pushZMax * (swingAmp + pitchAbs);
        m.method_46416(localDX, localDY, localDZ);

        m.method_22907(class_7833.field_40714.rotationDegrees(-swingAmp * OdysseyConfig.armSwingRotXDeg));
        m.method_22907(class_7833.field_40716.rotationDegrees( side   * swingAmp * OdysseyConfig.armSwingRotYDeg));
        m.method_22907(class_7833.field_40718.rotationDegrees( side   * swingAmp * OdysseyConfig.armSwingRotZDeg));
        m.method_22907(class_7833.field_40718.rotationDegrees(side * equipAmp * OdysseyConfig.armEquipRollDeg));
        m.method_22907(class_7833.field_40714.rotationDegrees(limitedPitch * OdysseyConfig.armPitchXDeg));

        m.method_22905(OdysseyConfig.heldScale, OdysseyConfig.heldScale, OdysseyConfig.heldScale);
    }

    private static void applyOverlayPose(class_4587 m, float side, float swingAmp, float equipAmp, float pitchNorm) {
        float x = side * OdysseyConfig.armBaseX;
        float y = OdysseyConfig.armBaseY - OdysseyConfig.dropYMax * swingAmp;
        float z = OdysseyConfig.armBaseZ + OdysseyConfig.pushZMax * swingAmp;

        m.method_46416(x, y, z);

        m.method_22907(class_7833.field_40714.rotationDegrees(OdysseyConfig.armRotX));
        m.method_22907(class_7833.field_40716.rotationDegrees(side * OdysseyConfig.armRotY));
        m.method_22907(class_7833.field_40718.rotationDegrees(side * OdysseyConfig.armRotZ));

        m.method_22907(class_7833.field_40714.rotationDegrees(-swingAmp * OdysseyConfig.armSwingRotXDeg));
        m.method_22907(class_7833.field_40716.rotationDegrees(side * swingAmp * OdysseyConfig.armSwingRotYDeg));
        m.method_22907(class_7833.field_40718.rotationDegrees(side * swingAmp * OdysseyConfig.armSwingRotZDeg));

        m.method_22907(class_7833.field_40718.rotationDegrees(side * equipAmp * OdysseyConfig.armEquipRollDeg));
        m.method_22907(class_7833.field_40714.rotationDegrees(pitchNorm * OdysseyConfig.armPitchXDeg));

        m.method_22905(OdysseyConfig.armScale, OdysseyConfig.armScale, OdysseyConfig.armScale);
    }
}
