package net.kronoz.odyssey.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import net.kronoz.odyssey.systems.physics.lightning.BetterLightningRenderer;
import net.minecraft.class_1538;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_919;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_919.class)
public abstract class LightningEntityRendererMixin {

    @Inject(
            method = "render(Lnet/minecraft/entity/LightningEntity;FFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V",
            at = @At("HEAD"),
            cancellable = true
    )
    private void ant$renderThinBetterLightning(class_1538 entity, float entityYaw, float tickDelta, class_4587 matrices, class_4597 consumers, int light, CallbackInfo ci) {
        ci.cancel();

        RenderSystem.enableBlend();
        BetterLightningRenderer.render(entity, matrices, consumers, tickDelta);
        RenderSystem.disableBlend();

    }
}
