// src/main/java/net/kronoz/odyssey/mixin/PlayerEntityMixin.java
package net.kronoz.odyssey.mixin;

import net.kronoz.odyssey.movement.WallRun;
import net.minecraft.class_1657;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1657.class)
public abstract class PlayerEntityMixin {
    @Unique private final WallRun.WallState odyssey$wall = new WallRun.WallState();

    @Inject(method = "tickMovement", at = @At("TAIL"))
    private void odyssey$wallRunTick(CallbackInfo ci) {
        class_1657 self = (class_1657)(Object)this;
        if (self.method_37908().field_9236) return;
        WallRun.tick(self, odyssey$wall);
    }

    @Inject(method = "jump", at = @At("TAIL"))
    private void odyssey$wallRunJumpBoost(CallbackInfo ci) {
        class_1657 self = (class_1657)(Object)this;
        if (self.method_37908().field_9236) return;
        WallRun.onJump(self, odyssey$wall);
    }
}
