// src/main/java/net/kronoz/odyssey/player/DashHandler.java
package net.kronoz.odyssey.movement;

import net.kronoz.odyssey.net.DashC2SPayload;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public final class DashHandler {
    private static final Map<UUID, Long> CD = new HashMap<>();
    private static final long COOLDOWN_MS = 650;
    private static final double BASE = 1.95;
    private static final double CARRY = 0.08;
    private static final double MAX_VY = 1.6;
    private static final double MAX_VH = 2.4;

    public static void onDashPacket(class_3222 p, DashC2SPayload pl) {
        long now = System.currentTimeMillis();
        if (now - CD.getOrDefault(p.method_5667(), 0L) < COOLDOWN_MS) return;

        class_243 dir = new class_243(pl.lx(), pl.ly(), pl.lz());
        if (dir.method_1027() < 1e-6) return;
        dir = dir.method_1029();

        class_243 carry = p.method_18798().method_1021(CARRY);
        double gain = BASE * pl.speed();

        class_243 dash = dir.method_1021(gain);
        double vh = Math.hypot(dash.field_1352, dash.field_1350);
        if (vh > MAX_VH) {
            double s = MAX_VH / vh;
            dash = new class_243(dash.field_1352 * s, dash.field_1351, dash.field_1350 * s);
        }
        if (Math.abs(dash.field_1351) > MAX_VY) {
            dash = new class_243(dash.field_1352, Math.copySign(MAX_VY, dash.field_1351), dash.field_1350);
        }

        p.method_18800(carry.field_1352 + dash.field_1352, Math.max(carry.field_1351, pl.up() + dash.field_1351), carry.field_1350 + dash.field_1350);
        p.field_6037 = true;
        p.method_37908().method_8396(null, p.method_24515(),
                net.minecraft.class_3417.field_14706,
                p.method_5634(), 0.7f, 1.45f);

        CD.put(p.method_5667(), now);
        p.method_7357().method_7906(net.minecraft.class_1802.field_8162, (int)(COOLDOWN_MS / 50));
    }
}
