// src/main/java/net/kronoz/odyssey/client/movement/MovementVisuals.java
package net.kronoz.odyssey.movement;

import net.minecraft.class_243;
import net.minecraft.class_746;

public final class MovementVisuals {
    private static float rollDeg = 0f;
    private static float rollTarget = 0f;
    private static double fovScale = 1.0;

    public static void clientTick(class_746 p) {
        if (p != null) {
            class_243 v = p.method_18798();
            double speed = v.method_1033();
            double target = 1.0 + Math.min(0.14, speed * 0.12);
            double alpha = 0.15;
            fovScale += (target - fovScale) * alpha;
        }
        float lerp = 0.10f;
        rollDeg += (rollTarget - rollDeg) * lerp;
        if (Math.abs(rollTarget - rollDeg) < 0.01f) rollDeg = rollTarget;
    }

    public static void updateWallTilt(class_746 p, WallRun.WallState s) {
        if (s != null && s.active() && s.normal != null) {
            class_243 look = p.method_5828(1).method_18805(1,0,1);
            if (look.method_1027() < 1e-6) look = new class_243(1,0,0);
            class_243 right = new class_243(look.field_1350, 0, -look.field_1352).method_1029();
            double side = right.method_1026(s.normal);
            rollTarget = side >= 0 ? -30f : 30f;
        } else rollTarget = 0f;
    }

    public static double fovScale() { return fovScale; }
    public static float rollDegrees() { return rollDeg; }
}
