// src/main/java/net/kronoz/odyssey/movement/WallRun.java
package net.kronoz.odyssey.movement;

import net.kronoz.odyssey.init.ModBlocks;
import net.minecraft.class_1657;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;

public final class WallRun {
    private static final int HOLD_TICKS = 24;
    private static final int DECAY_TICKS = 32;
    private static final double GRAVITY_HOLD = 0.22;
    private static final double GRAVITY_DECAY_MIN = 0.55;
    private static final double GRAVITY_DECAY_MAX = 1.15;
    private static final double STICK = 0.085;
    private static final double ALONG_GAIN = 0.055;
    private static final double START_MIN_HSPEED = 0.02;
    private static final double PROBE_DIST = 0.6;
    private static final double PROBE_STEP_Y = 0.9;

    public static boolean canStart(class_1657 p) {
        if (p.method_7325() || p.method_5681() || p.method_6128() || p.method_5771()) return false;
        if (p.method_24828()) return false;
        class_243 vh = p.method_18798().method_18805(1, 0, 1);
        if (vh.method_1027() < START_MIN_HSPEED * START_MIN_HSPEED) return false;
        return findWallNormal(p) != null;
    }

    private static boolean isWallRunnable(class_2248 b) {
        return b == ModBlocks.WALLRUN;

    }

    private static class_243 findWallNormal(class_1657 p) {
        class_243 pos = p.method_19538();
        class_2350[] dirs = {class_2350.field_11034, class_2350.field_11039, class_2350.field_11035, class_2350.field_11043};
        for (int y = 0; y < 2; y++) {
            double yOff = y * PROBE_STEP_Y;
            for (class_2350 d : dirs) {
                class_243 off = new class_243(d.method_10148(), 0, d.method_10165()).method_1029().method_1021(PROBE_DIST);
                class_2338 bp = class_2338.method_49638(pos.method_1019(off).method_1031(0, yOff, 0));
                class_2680 st = p.method_37908().method_8320(bp);
                if (!st.method_26215() && isWallRunnable(st.method_26204())) {
                    return new class_243(-d.method_10148(), 0, -d.method_10165()).method_1029();
                }
            }
        }
        return null;
    }

    private static class_243 wallTangent(class_243 normal, class_243 prefer) {
        class_243 t1 = new class_243(-normal.field_1350, 0, normal.field_1352).method_1029();
        class_243 t2 = t1.method_1021(-1);
        return prefer.method_1026(t1) >= prefer.method_1026(t2) ? t1 : t2;
    }

    public static void tick(class_1657 p, WallState s) {
        if (s.remaining <= 0) {
            class_243 n = findWallNormal(p);
            if (!canStart(p) || n == null) return;
            s.remaining = HOLD_TICKS + DECAY_TICKS;
            s.normal = n;
        } else {
            class_243 n = findWallNormal(p);
            if (n == null || p.method_24828()) { s.reset(); return; }
            s.normal = n;
        }

        class_243 v = p.method_18798();
        class_243 look = p.method_5828(1).method_18805(1, 0, 1);
        class_243 prefer = v.method_18805(1, 0, 1).method_1027() > 1e-6 ? v : look;
        class_243 tangent = wallTangent(s.normal, prefer).method_1029();

        int decayed = Math.max(0, (HOLD_TICKS + DECAY_TICKS) - s.remaining - HOLD_TICKS);
        double g;
        if (s.remaining > DECAY_TICKS) g = GRAVITY_HOLD;
        else {
            double t = 1.0 - (s.remaining / (double) DECAY_TICKS);
            g = GRAVITY_DECAY_MIN + (GRAVITY_DECAY_MAX - GRAVITY_DECAY_MIN) * t;
        }

        double vy = v.field_1351 > -0.02 ? v.field_1351 : v.field_1351 * g;
        double fx = v.field_1352 + tangent.field_1352 * ALONG_GAIN + s.normal.field_1352 * -STICK;
        double fz = v.field_1350 + tangent.field_1350 * ALONG_GAIN + s.normal.field_1350 * -STICK;

        p.method_18800(fx, vy, fz);
        p.field_6017 = 0;

        if (decayed > DECAY_TICKS / 2) p.method_18799(p.method_18798().method_18805(0.995, 1, 0.995));

        s.remaining--;
        if (s.remaining <= 0) s.reset();
    }

    public static void onJump(class_1657 p, WallState s) {
        if (!s.active()) return;
        class_243 look = p.method_5828(1).method_18805(1,0,1);
        if (look.method_1027() < 1e-6) look = new class_243(1,0,0);
        class_243 right = new class_243(look.field_1350, 0, -look.field_1352).method_1029();
        double side = right.method_1026(s.normal);
        class_243 kickSide = side >= 0 ? right.method_1021(-1) : right;
        class_243 tangent = wallTangent(s.normal, look).method_1029();

        double upBoost = 0.9;
        double sidePush = 0.55;
        double along = 0.18;

        p.method_5762(
                kickSide.field_1352 * sidePush + tangent.field_1352 * along,
                upBoost,
                kickSide.field_1350 * sidePush + tangent.field_1350 * along
        );
        p.field_6037 = true;
        p.field_6017 = 0;
        s.reset();
    }

    public static final class WallState {
        public int remaining = 0;
        public class_243 normal = null;
        public boolean active() { return remaining > 0 && normal != null; }
        public void reset() { remaining = 0; normal = null; }
    }
}
