package net.kronoz.odyssey.net;

import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.kronoz.odyssey.Odyssey;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public final class BodyModPackets {

    // --- Codecs custom (évite les constantes manquantes) ---
    public static final class_9139<class_9129, class_2960> IDENT_CODEC = new class_9139<>() {
        @Override public void encode(class_9129 buf, class_2960 value) { buf.method_10812(value); }
        @Override public class_2960 decode(class_9129 buf) { return buf.method_10810(); }
    };
    public static final class_9139<class_9129, UUID> UUID_CODEC = new class_9139<>() {
        @Override public void encode(class_9129 buf, UUID value) { buf.method_10797(value); }
        @Override public UUID decode(class_9129 buf) { return buf.method_10790(); }
    };
    public static final class_9139<class_9129, Map<String, class_2960>> MAP_STRING_IDENT_CODEC =
            class_9135.method_56377(HashMap::new, class_9135.field_48554, IDENT_CODEC);

    // --- Payloads ---

    public static final class ApplyPartC2S implements class_8710 {
        public static final class_9154<ApplyPartC2S> ID = new class_9154<>(Odyssey.id("apply_part"));
        public static final class_9139<class_9129, ApplyPartC2S> CODEC =
                class_9139.method_56435(
                        class_9135.field_48554, p -> p.slot,
                        IDENT_CODEC,          p -> p.partId,
                        ApplyPartC2S::new);

        public final String slot;
        public final class_2960 partId;
        public ApplyPartC2S(String slot, class_2960 partId){ this.slot = slot; this.partId = partId; }
        @Override public class_9154<? extends class_8710> method_56479() { return ID; }
    }

    public static final class ClearSlotC2S implements class_8710 {
        public static final class_9154<ClearSlotC2S> ID = new class_9154<>(Odyssey.id("clear_slot"));
        public static final class_9139<class_9129, ClearSlotC2S> CODEC =
                class_9139.method_56434(class_9135.field_48554, p -> p.slot, ClearSlotC2S::new);

        public final String slot;
        public ClearSlotC2S(String slot){ this.slot = slot; }
        @Override public class_9154<? extends class_8710> method_56479() { return ID; }
    }

    public static final class SyncBodyS2C implements class_8710 {
        public static final class_9154<SyncBodyS2C> ID = new class_9154<>(Odyssey.id("sync_body"));
        public static final class_9139<class_9129, SyncBodyS2C> CODEC =
                class_9139.method_56435(
                        UUID_CODEC,               p -> p.player,
                        MAP_STRING_IDENT_CODEC,   p -> p.equipped,
                        SyncBodyS2C::new);

        public final UUID player;
        public final Map<String, class_2960> equipped;
        public SyncBodyS2C(UUID player, Map<String, class_2960> equipped){
            this.player = player; this.equipped = equipped;
        }
        @Override public class_9154<? extends class_8710> method_56479() { return ID; }
    }

    public static void registerTypes(){
        PayloadTypeRegistry.playC2S().register(ApplyPartC2S.ID, ApplyPartC2S.CODEC);
        PayloadTypeRegistry.playC2S().register(ClearSlotC2S.ID, ClearSlotC2S.CODEC);
        PayloadTypeRegistry.playS2C().register(SyncBodyS2C.ID, SyncBodyS2C.CODEC);
    }
}
