package net.kronoz.odyssey.net;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.kronoz.odyssey.Odyssey;
import net.kronoz.odyssey.systems.cinematics.runtime.CutsceneManager;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;

public final class CineNetworking {
    private CineNetworking(){}

    /* =====================  PAYLOADS  ===================== */

    public record PlayPayload(String sceneId, double speed) implements class_8710 {
        public static final class_9154<PlayPayload> ID = new class_9154<>(class_2960.method_60655(Odyssey.MODID, "play"));
        public static final class_9139<class_9129, PlayPayload> CODEC =
                class_9139.method_56435(
                        class_9135.field_48554, PlayPayload::sceneId,
                        class_9135.field_48553, PlayPayload::speed,
                        PlayPayload::new
                );
        @Override public class_9154<? extends class_8710> method_56479() { return ID; }
    }

    public record StopPayload() implements class_8710 {
        public static final class_9154<StopPayload> ID = new class_9154<>(class_2960.method_60655(Odyssey.MODID, "stop"));

        public static final class_9139<class_9129, StopPayload> CODEC =
                class_9139.method_56438((buf, value) -> {  }, buf -> new StopPayload());

        @Override public class_9154<? extends class_8710> method_56479() { return ID; }
    }



    public record SpeedPayload(double speed) implements class_8710 {
        public static final class_9154<SpeedPayload> ID = new class_9154<>(class_2960.method_60655(Odyssey.MODID, "speed"));
        public static final class_9139<class_9129, SpeedPayload> CODEC =
                class_9139.method_56434(
                        class_9135.field_48553, SpeedPayload::speed,
                        SpeedPayload::new
                );
        @Override public class_9154<? extends class_8710> method_56479() { return ID; }
    }

    /* =====================  REGISTRATION  ===================== */

    public static void registerCommon() {
        PayloadTypeRegistry.playS2C().register(PlayPayload.ID, PlayPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(StopPayload.ID, StopPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(SpeedPayload.ID, SpeedPayload.CODEC);
    }

    @Environment(EnvType.CLIENT)
    public static void registerClient() {
        ClientPlayNetworking.registerGlobalReceiver(PlayPayload.ID, (payload, context) -> {
            var client = context.client();
            client.execute(() -> {
                if (CutsceneManager.I.play(payload.sceneId())) {
                    CutsceneManager.I.setSpeed(payload.speed());
                }
            });
        });

        ClientPlayNetworking.registerGlobalReceiver(StopPayload.ID, (payload, context) ->
                context.client().execute(CutsceneManager.I::stop)
        );

        ClientPlayNetworking.registerGlobalReceiver(SpeedPayload.ID, (payload, context) ->
                context.client().execute(() -> CutsceneManager.I.setSpeed(payload.speed()))
        );
    }

    /* =====================  SERVER SEND HELPERS  ===================== */

    public static void playAll(MinecraftServer server, String id, double speed) {
        var payload = new PlayPayload(id, speed);
        for (class_3222 p : server.method_3760().method_14571()) {
            ServerPlayNetworking.send(p, payload);
        }
    }

    public static void stopAll(MinecraftServer server) {
        var payload = new StopPayload();
        for (class_3222 p : server.method_3760().method_14571()) {
            ServerPlayNetworking.send(p, payload);
        }
    }

    public static void speedAll(MinecraftServer server, double speed) {
        var payload = new SpeedPayload(speed);
        for (class_3222 p : server.method_3760().method_14571()) {
            ServerPlayNetworking.send(p, payload);
        }
    }
}
