package net.kronoz.odyssey.particle;

import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.light.data.PointLightData;
import foundry.veil.api.client.render.light.renderer.LightRenderHandle;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4003;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.client.particle.*;
import org.jetbrains.annotations.Nullable;

public class SentryShieldFullParticle extends class_4003 {
    private final class_4002 sprites;

    private static final float PARTICLE_SCALE = 5f;

    private float lifeProgress = (float)this.field_3866 / (float)this.field_3847;

    private static final float BODY_LIGHT_BRIGHTNESS = 0.2f;
    private static final float BODY_LIGHT_RADIUS     = 5f;
    private static final float BODY_R = 1.00f, BODY_G = 1.00f, BODY_B = 5.00f;

    private PointLightData bodyLight;
    private LightRenderHandle<PointLightData> bodyLightHandle;

    public SentryShieldFullParticle(class_638 clientWorld, double x, double y, double z,
                               class_4002 spriteProvider, double xSpeed, double ySpeed, double zSpeed) {
        super(clientWorld, x, y, z, xSpeed, ySpeed, zSpeed);

        this.method_18142(spriteProvider);

        this.sprites = spriteProvider;


        this.method_3087(7f);


        this.field_3847 = 5;


        this.field_3852 = 0;
        this.field_3869 = 0;
        this.field_3850 = 0;
    }








    @Override
    public void method_3070() {
        super.method_3070();
        this.method_18142(this.sprites);

        float lifeProgress = (float)this.field_3866 / (float)this.field_3847;
//        float finalScale =  MathHelper.lerp(lifeProgress, PARTICLE_SCALE, PARTICLE_SCALE * 0.2f);






        this.field_3841 = class_3532.method_16439(lifeProgress, 1f, 0.1f);
        boolean alive = this.method_3086() && !this.field_3843;
        if (alive) {
            if (bodyLightHandle == null || !bodyLightHandle.isValid()) {

                class_243 p = new class_243(this.field_3874, this.field_3854, this.field_3871);
                bodyLight = new PointLightData()
                        .setBrightness(BODY_LIGHT_BRIGHTNESS)
                        .setColor(BODY_R, BODY_G, BODY_B )
                        .setRadius(BODY_LIGHT_RADIUS)
                        .setPosition(p.field_1352, p.field_1351, p.field_1350);
                bodyLightHandle = VeilRenderSystem.renderer().getLightRenderer().addLight(bodyLight);
            } else {
                class_243 p = new class_243(this.field_3874, this.field_3854, this.field_3871);




                float brightness = class_3532.method_16439(lifeProgress, BODY_LIGHT_BRIGHTNESS, 0.01f);


                float r = 1.0f;
                float g = 0.0f;
                float b = 1.0f + lifeProgress * 0.5f;

                float radius = class_3532.method_16439(lifeProgress, BODY_LIGHT_RADIUS, 8f);

                bodyLight
                        .setBrightness(brightness)
                        .setColor(r, g, b)
                        .setRadius(radius)
                        .setPosition(p.field_1352, p.field_1351, p.field_1350);
                bodyLightHandle.markDirty();
            }
        } else {
            freeLight();
        }

    }

    private void freeLight() {
        if (bodyLightHandle != null && bodyLightHandle.isValid()) {
            bodyLightHandle.free();
        }
        bodyLightHandle = null;
        bodyLight = null;
    }

    @Override
    public int method_3068(float tint) {
        return 0xF000F0; // max brightness
    }

    @Override
    public class_3999 method_18122() {
        return class_3999.field_17830;
    }

    public static class Factory implements class_707<class_2400> {
        private final class_4002 spriteProvider;

        public Factory(class_4002 spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        @Override
        public @Nullable class_703 createParticle(class_2400 parameters, class_638 world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new SentryShieldFullParticle(world, x, y, z, this.spriteProvider, velocityX, velocityY, velocityZ);
        }
    }
}
