package net.kronoz.odyssey.systems.cinematics.runtime;

import net.kronoz.odyssey.systems.cinematics.track.CameraPose;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4184;


public final class CutscenePlayer {
    private final Cutscene cutscene;
    private double t;
    private boolean playing;

    private double speed = 1.0;

    private boolean anchorCaptured = false;
    private class_243 anchorPos = class_243.field_1353;
    private float anchorYaw = 0f, anchorPitch = 0f;

    public CutscenePlayer(Cutscene cutscene){
        this.cutscene = cutscene;
    }

    public void play(){
        t = 0.0;
        playing = true;
        anchorCaptured = false;
    }

    public void stop(){ playing = false; }

    public void seek(double timeSec){ t = Math.max(0.0, timeSec); }

    public void setSpeed(double speed){ this.speed = Math.max(0.001, speed); }

    public double getSpeed(){ return speed; }

    private void ensureAnchor(){
        if(anchorCaptured) return;
        if(cutscene.mode() != Cutscene.CameraMode.ABSOLUTE || !cutscene.anchorToStart()) return;

        var mc = class_310.method_1551();
        if(mc == null) return;
        class_4184 cam = mc.field_1773.method_19418();
        anchorPos = cam.method_19326();
        anchorYaw = cam.method_19330();
        anchorPitch = cam.method_19329();
        anchorCaptured = true;
    }

    public void tick(double dtSec){
        if(!playing) return;

        t += dtSec * speed;

        double trackDur = cutscene.durationSec() > 0 ? Math.min(cutscene.durationSec(), cutscene.camera().duration())
                : cutscene.camera().duration();
        if(t >= trackDur){
            t = trackDur;
            playing = false;
        }

        ensureAnchor();

        CameraPose pose = cutscene.camera().sample(t);

        var ctrl = CameraOverrideController.I;
        ctrl.active = true;
        ctrl.fov = pose.fov();
        ctrl.lockX = pose.lockX();
        ctrl.lockY = pose.lockY();
        ctrl.lockZ = pose.lockZ();

        if(cutscene.mode() == Cutscene.CameraMode.ADDITIVE_FOLLOW){
            ctrl.mode = CameraOverrideController.Mode.ADDITIVE_FOLLOW;
            ctrl.offsetX = pose.position().field_1352;
            ctrl.offsetY = pose.position().field_1351;
            ctrl.offsetZ = pose.position().field_1350;
            ctrl.yawOffset = pose.yaw();
            ctrl.pitchOffset = pose.pitch();
        } else {
            ctrl.mode = CameraOverrideController.Mode.ABSOLUTE;

            class_243 basePos = anchorCaptured ? anchorPos : class_310.method_1551().field_1773.method_19418().method_19326();
            float baseYaw = anchorCaptured ? anchorYaw : class_310.method_1551().field_1773.method_19418().method_19330();
            float basePitch = anchorCaptured ? anchorPitch : class_310.method_1551().field_1773.method_19418().method_19329();

            ctrl.posX = basePos.field_1352 + pose.position().field_1352;
            ctrl.posY = basePos.field_1351 + pose.position().field_1351;
            ctrl.posZ = basePos.field_1350 + pose.position().field_1350;

            ctrl.yaw = baseYaw + pose.yaw();
            ctrl.pitch = basePitch + pose.pitch();
        }
    }

    public boolean isPlaying(){ return playing; }
}
