package net.kronoz.odyssey.systems.cinematics.track;

import net.kronoz.odyssey.systems.cinematics.api.Curves;
import net.kronoz.odyssey.systems.cinematics.api.Easing;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public final class CameraTrack {
    private final List<CameraKeyframe> keys = new ArrayList<>();

    public CameraTrack add(CameraKeyframe k){
        keys.add(k);
        keys.sort(Comparator.comparingDouble(CameraKeyframe::timeSec));
        return this;
    }

    public double duration(){
        return keys.isEmpty()?0:keys.getLast().timeSec();
    }

    public CameraPose sample(double t){
        if(keys.isEmpty()) return new CameraPose(class_243.field_1353,0,0,0,70f,false,false,false);
        if(t <= keys.getFirst().timeSec()) return resolve(keys.getFirst());
        if(t >= keys.getLast().timeSec())  return resolve(keys.getLast());

        CameraKeyframe a=null,b=null;
        for(int i=0;i<keys.size()-1;i++){
            var k0=keys.get(i);
            var k1=keys.get(i+1);
            if(t>=k0.timeSec() && t<=k1.timeSec()){ a=k0; b=k1; break; }
        }
        if(a==null||b==null) return resolve(keys.getLast());

        double span = b.timeSec() - a.timeSec();
        double lt = (t - a.timeSec()) / (span<=0?1:span);
        double et = (b.easing()!=null?b.easing(): Easing.LINEAR).apply(Math.max(0,Math.min(1,lt)));

        CameraPose pa = resolve(a);
        CameraPose pb = resolve(b);

        class_243 p = Curves.lerp(pa.position(), pb.position(), et);
        if(b.pose().lockX()) p = new class_243(pa.position().field_1352, p.field_1351, p.field_1350);
        if(b.pose().lockY()) p = new class_243(p.field_1352, pa.position().field_1351, p.field_1350);
        if(b.pose().lockZ()) p = new class_243(p.field_1352, p.field_1351, pa.position().field_1350);

        float yaw   = Curves.lerp(pa.yaw(),   pb.yaw(),   et);
        float pitch = Curves.lerp(pa.pitch(), pb.pitch(), et);
        float roll  = Curves.lerp(pa.roll(),  pb.roll(),  et);
        float fov   = Curves.lerp(pa.fov(),   pb.fov(),   et);

        return new CameraPose(p,yaw,pitch,roll,fov,b.pose().lockX(),b.pose().lockY(),b.pose().lockZ());
    }

    private CameraPose resolve(CameraKeyframe k){
        var base = k.pose();
        if(!k.relativeToPlayer()) return base;

        var mc = class_310.method_1551();
        class_1657 p = mc.field_1724;
        if(p==null) return base;

        class_238 box = p.method_5829();
        class_243 dims = new class_243(box.method_17939(), box.method_17940(), box.method_17941());

        double s = Math.max(1e-3, k.relFactor());
        class_243 delta = new class_243(
                base.position().field_1352 * dims.field_1352 * s,
                base.position().field_1351 * dims.field_1351 * s,
                base.position().field_1350 * dims.field_1350 * s
        );
        class_243 pos = p.method_19538().method_1019(delta);

        return new CameraPose(
                pos,
                base.yaw(),
                base.pitch(),
                base.roll(),
                base.fov(),
                base.lockX(), base.lockY(), base.lockZ()
        );
    }
}
