package net.kronoz.odyssey.systems.dialogue.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.kronoz.odyssey.systems.dialogue.Dialogue;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_4013;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class DialogueLoader {
    private static final Gson G = new Gson();
    private static final Map<class_2960, DialogueTree> TREES = new HashMap<>();

    public static void init() {
        ResourceManagerHelper.get(class_3264.field_14190).registerReloadListener(new Reloader());
    }
    public static DialogueTree get(class_2960 id){ return TREES.get(id); }

    static final class Reloader implements class_4013, class_3302, IdentifiableResourceReloadListener {
        @Override public class_2960 getFabricId(){ return class_2960.method_60655(Dialogue.MODID, "dialogue_loader"); }

        @Override
        public Collection<class_2960> getFabricDependencies() {
            return IdentifiableResourceReloadListener.super.getFabricDependencies();
        }

        @Override
        public void method_14491(class_3300 manager) {
            TREES.clear();
            // PAS de slash final !!
            final String prefix = Dialogue.MODID + "/dialogue";

            manager.method_14488(prefix, id -> id.method_12832().endsWith(".json"))
                    .forEach((id, res) -> {
                        try (InputStreamReader r = new InputStreamReader(res.method_14482())) {
                            JsonObject root = G.fromJson(r, JsonObject.class);

                            // id du fichier ou "id" explicite dans le json
                            class_2960 treeId = root.has("id") ? class_2960.method_60654(root.get("id").getAsString()) : id;
                            String start = root.get("start").getAsString();

                            Map<String, DialogueNode> nodes = new HashMap<>();
                            for (Map.Entry<String, JsonElement> n : root.getAsJsonObject("nodes").entrySet()) {
                                nodes.put(n.getKey(), DialogueNode.fromJson(n.getValue().getAsJsonObject(), n.getKey()));
                            }
                            TREES.put(treeId, new DialogueTree(treeId, start, nodes));
                        } catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    });
        }

    }
}
