package net.kronoz.odyssey.systems.dialogue.net.c2s;

import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.kronoz.odyssey.systems.dialogue.net.Packets;
import net.minecraft.class_2540;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

// Payload CLIENT -> SERVEUR
public record SelectChoiceC2S(String choiceId) implements class_8710 {
    public static final class_9154<SelectChoiceC2S> ID = new class_9154<>(Packets.SELECT_CHOICE_ID);
    public static final class_9139<class_2540, SelectChoiceC2S> CODEC =
            class_9139.method_56434(class_9135.field_48554, SelectChoiceC2S::choiceId, SelectChoiceC2S::new);

    @Override public class_9154<? extends class_8710> method_56479() { return ID; }

    // --- Envoi côté client
    public static void sendClient(String choiceId) {
        ClientPlayNetworking.send(new SelectChoiceC2S(choiceId));
    }

    // --- Enregistrement (à appeler depuis Packets.initCommon)
    public static void register() {
        PayloadTypeRegistry.playC2S().register(ID, CODEC);
        ServerPlayNetworking.registerGlobalReceiver(ID, SelectChoiceC2S::handle);
    }

    // --- Réception côté serveur (contexte Fabric 1.21.1)
    private static void handle(SelectChoiceC2S payload,
                               net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking.Context ctx) {
        var player = ctx.player();
        var server = player.method_5682();
        if (server == null) return;
        server.execute(() -> net.kronoz.odyssey.systems.dialogue.server.DialogueManager.selectChoice(player, payload.choiceId()));
    }
}
