package net.kronoz.odyssey.systems.dialogue.net.s2c;

import io.netty.buffer.ByteBuf;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.kronoz.odyssey.systems.dialogue.data.DialogueLine;
import net.kronoz.odyssey.systems.dialogue.net.Packets;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import java.util.Optional;

// Payload SERVEUR -> CLIENT
public record PlayLineS2C(String caption, Optional<class_2960> soundId, int durationMs) implements class_8710 {
    public static final class_9154<PlayLineS2C> ID = new class_9154<>(Packets.PLAY_LINE_ID);
    private static final class_9139<ByteBuf, Optional<class_2960>> OPT_ID =
            class_9135.method_56382(class_2960.field_48267);

    public static final class_9139<class_2540, PlayLineS2C> CODEC =
            class_9139.method_56436(
                    class_9135.field_48554, PlayLineS2C::caption,
                    OPT_ID,               PlayLineS2C::soundId,
                    class_9135.field_48550, PlayLineS2C::durationMs,
                    PlayLineS2C::new
            );

    @Override public class_9154<? extends class_8710> method_56479() { return ID; }

    // --- Envoi côté serveur
    public static void send(class_3222 p, DialogueLine line){
        ServerPlayNetworking.send(p, new PlayLineS2C(
                line.caption(),
                Optional.ofNullable(line.soundId()),
                Math.max(1, line.durationMs())
        ));
    }

    // --- Enregistrement (à appeler depuis Packets.initClient)
    public static void registerClient() {
        PayloadTypeRegistry.playS2C().register(ID, CODEC);
        ClientPlayNetworking.registerGlobalReceiver(ID, PlayLineS2C::handle);
    }

    private static void handle(PlayLineS2C payload,
                               net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking.Context ctx) {
        var client = ctx.client();
        client.execute(() -> {
            client.field_1705.method_1758(class_2561.method_43470(payload.caption()), false); // <- overlay au-dessus de la hotbar
            payload.soundId().ifPresent(snd -> {
                var ev = net.minecraft.class_3414.method_47908(snd);
                client.method_1483().method_4873(net.minecraft.class_1109.method_4758(ev, 1.0f));
            });
        });
    }
}
