package net.kronoz.odyssey.systems.dialogue.net.s2c;

import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.kronoz.odyssey.systems.dialogue.data.DialogueChoice;
import net.kronoz.odyssey.systems.dialogue.net.Packets;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import java.util.List;

// Payload SERVEUR -> CLIENT
public record ShowChoicesS2C(boolean multi, List<DialogueChoice> choices) implements class_8710 {
    public static final class_9154<ShowChoicesS2C> ID = new class_9154<>(Packets.SHOW_CHOICES_ID);

    // Petit codec DialogueChoice (id + text uniquement côté client)
    private static final class_9139<class_2540, DialogueChoice> CHOICE_CODEC =
            class_9139.method_56435(
                    class_9135.field_48554, DialogueChoice::id,
                    class_9135.field_48554, DialogueChoice::text,
                    (id, text) -> new DialogueChoice(id, text, "")
            );

    public static final class_9139<class_2540, ShowChoicesS2C> CODEC =
            class_9139.method_56435(
                    class_9135.field_48547,                      ShowChoicesS2C::multi,
                    CHOICE_CODEC.method_56433(class_9135.method_56363()), ShowChoicesS2C::choices,
                    ShowChoicesS2C::new
            );

    @Override public class_9154<? extends class_8710> method_56479() { return ID; }

    // --- Envoi côté serveur
    public static void send(class_3222 p, boolean multi, List<DialogueChoice> list){
        ServerPlayNetworking.send(p, new ShowChoicesS2C(multi, list));
    }

    // --- Enregistrement (à appeler depuis Packets.initClient)
    public static void registerClient(){
        PayloadTypeRegistry.playS2C().register(ID, CODEC);
        ClientPlayNetworking.registerGlobalReceiver(ID, ShowChoicesS2C::handle);
    }

    // --- Réception côté client
    private static void handle(ShowChoicesS2C payload,
                               net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking.Context ctx){
        var client = ctx.client();
        client.execute(() -> client.method_1507(new net.kronoz.odyssey.systems.dialogue.client.ChoiceScreen(payload.multi(), payload.choices())));
    }
}
