package net.kronoz.odyssey.systems.physics.dust;

import org.joml.Matrix4f;
import org.joml.Vector3f;

import java.util.Random;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;

public final class DustField {
    private static final int FULL_BRIGHT = 0x00F000F0;
    private static final int OVERLAY     = class_4608.field_21444;

    private static final double LIFE_MIN = 20.0;
    private static final double LIFE_MAX = 40.5;
    private static final double SIZE_MIN = 0.01;
    private static final double SIZE_MAX = 0.02;

    private static final class_243  BASE_DIR   = new class_243(0.0, -1.0, 0.0);
    private static final double BASE_SPEED = 0.075;

    private static final double SPREAD_MAX = BASE_SPEED * 0.8;
    private static final double SPREAD_GAMMA = 3.0;
    private static final double SPEED_JITTER = 0.40;
    private static final double SPREAD_JITTER = 0.50;

    private static final double ROT_DRAG = 0.995;

    private final Node[] nodes;
    private final Random rng = new Random();

    private final float r, g, b;
    private final double emitPerSecond;
    private double emitAcc = 0.0;
    private int alive = 0;
    private int nextDead = 0;

    public DustField(int capacity, int r255, int g255, int b255, double emitRatePerSecond) {
        this.r = class_3532.method_15363(r255 / 255f, 0f, 1f);
        this.g = class_3532.method_15363(g255 / 255f, 0f, 1f);
        this.b = class_3532.method_15363(b255 / 255f, 0f, 1f);
        this.emitPerSecond = Math.max(0.0, emitRatePerSecond);
        this.nodes = new Node[capacity];
        for (int i = 0; i < capacity; i++) nodes[i] = Node.dead();
    }

    private static final class Node {
        boolean alive;
        class_243 p;
        class_243 radialDirXZ;
        double downSpeed;
        double radialMaxSpeed;
        float yaw, pitch, roll;
        float yawVel, pitchVel, rollVel;

        double age, life, size;

        static Node dead() {
            Node n = new Node();
            n.alive = false; n.p = class_243.field_1353;
            n.radialDirXZ = class_243.field_1353;
            n.downSpeed = 0; n.radialMaxSpeed = 0;
            n.yaw = n.pitch = n.roll = 0f;
            n.yawVel = n.pitchVel = n.rollVel = 0f;
            n.age = 0; n.life = 0; n.size = 0;
            return n;
        }
    }

    private void spawn(Node n, class_243 origin) {
        class_243 j = new class_243(
                (rng.nextDouble()-0.5)*0.35,
                (rng.nextDouble()-0.5)*0.35,
                (rng.nextDouble()-0.5)*0.35
        );
        n.p = origin.method_1019(j);

        double ang = rng.nextDouble() * Math.PI * 2.0;
        n.radialDirXZ = new class_243(Math.cos(ang), 0.0, Math.sin(ang));

        double downMul   = 1.0 + (rng.nextDouble()*2.0 - 1.0) * SPEED_JITTER;
        double spreadMul = 1.0 + (rng.nextDouble()*2.0 - 1.0) * SPREAD_JITTER;
        n.downSpeed      = BASE_SPEED * downMul;
        n.radialMaxSpeed = SPREAD_MAX * spreadMul;

        n.life = LIFE_MIN + rng.nextDouble()*(LIFE_MAX - LIFE_MIN);
        n.age = 0.0;
        n.size = SIZE_MIN + rng.nextDouble()*(SIZE_MAX - SIZE_MIN);

        n.yaw   = (float)(rng.nextDouble()*Math.PI*2);
        n.pitch = (float)((rng.nextDouble()-0.5)*0.25);
        n.roll  = (float)((rng.nextDouble()-0.5)*0.25);
        n.yawVel   = (float)((rng.nextDouble()-0.5)*0.20);
        n.pitchVel = (float)((rng.nextDouble()-0.5)*0.20);
        n.rollVel  = (float)((rng.nextDouble()-0.5)*0.20);

        n.alive = true;
    }

    public void update(double dt, class_243 origin, class_1937 world, long worldTime) {
        if (dt <= 0) return;

        if (alive < nodes.length && emitPerSecond > 0) {
            emitAcc += emitPerSecond * dt;
            while (emitAcc >= 1.0 && alive < nodes.length) {
                int start = nextDead;
                do {
                    Node n = nodes[nextDead];
                    if (!n.alive) {
                        spawn(n, origin);
                        alive++;
                        emitAcc -= 1.0;
                        nextDead = (nextDead + 1) % nodes.length;
                        break;
                    }
                    nextDead = (nextDead + 1) % nodes.length;
                } while (nextDead != start);
                if (start == nextDead) break;
            }
        }

        for (Node n : nodes) {
            if (!n.alive) continue;

            n.age += dt;
            if (n.age >= n.life) { n.alive = false; alive--; continue; }
            double t = class_3532.method_15350(n.age / n.life, 0.0, 1.0);
            double g = t*t*(3.0 - 2.0*t);
            g = Math.pow(g, SPREAD_GAMMA);

            class_243 vDown   = BASE_DIR.method_1021(n.downSpeed);
            class_243 vLateral= n.radialDirXZ.method_1021(n.radialMaxSpeed * g);
            class_243 v       = vDown.method_1019(vLateral);

            n.p = n.p.method_1019(v.method_1021(dt));

            n.yaw   += n.yawVel   * dt; n.yawVel   *= ROT_DRAG;
            n.pitch += n.pitchVel * dt; n.pitchVel *= ROT_DRAG;
            n.roll  += n.rollVel  * dt; n.rollVel  *= ROT_DRAG;
        }
    }

    public void render(class_4587 ms, class_4588 vc, class_243 cameraBase, float tickDelta, class_1937 world) {
        Matrix4f m4 = ms.method_23760().method_23761();

        for (Node n : nodes) {
            if (!n.alive) continue;

            double t = class_3532.method_15350(n.age / n.life, 0.0, 1.0);
            float fade = (float)(Math.min(1.0, t*3.0) * Math.pow(1.0 - t, 1.5));
            int lx = world.method_8314(net.minecraft.class_1944.field_9282, net.minecraft.class_2338.method_49638(n.p));
            int ls = world.method_8314(net.minecraft.class_1944.field_9284,   net.minecraft.class_2338.method_49638(n.p));
            float lfac = class_3532.method_15363((lx*0.8f + ls*0.5f)/30f, 0.08f, 1.0f);

            float a = class_3532.method_15363(0.06f + 0.22f * fade * lfac, 0f, 0.35f);
            float edge = (float)n.size;
            float hs = edge * 0.5f;

            float cx = (float)(n.p.field_1352 - cameraBase.field_1352);
            float cy = (float)(n.p.field_1351 - cameraBase.field_1351);
            float cz = (float)(n.p.field_1350 - cameraBase.field_1350);

            float cyw = (float)Math.cos(n.yaw), syw = (float)Math.sin(n.yaw);
            float cpi = (float)Math.cos(n.pitch), spi = (float)Math.sin(n.pitch);
            float cro = (float)Math.cos(n.roll),  sro = (float)Math.sin(n.roll);

            Vector3f X = new Vector3f(1,0,0);
            Vector3f Y = new Vector3f(0,1,0);
            Vector3f Z = new Vector3f(0,0,1);

            X = new Vector3f(cyw*X.x - syw*X.z, X.y, syw*X.x + cyw*X.z);
            Y = new Vector3f(cyw*Y.x - syw*Y.z, Y.y, syw*Y.x + cyw*Y.z);
            Z = new Vector3f(cyw*Z.x - syw*Z.z, Z.y, syw*Z.x + cyw*Z.z);

            X = new Vector3f(X.x,  cpi*X.y - spi*X.z,  spi*X.y + cpi*X.z);
            Y = new Vector3f(Y.x,  cpi*Y.y - spi*Y.z,  spi*Y.y + cpi*Y.z);
            Z = new Vector3f(Z.x,  cpi*Z.y - spi*Z.z,  spi*Z.y + cpi*Z.z);

            X = new Vector3f( cro*X.x - sro*X.y, sro*X.x + cro*X.y, X.z);
            Y = new Vector3f( cro*Y.x - sro*Y.y, sro*Y.x + cro*Y.y, Y.z);
            Z = new Vector3f( cro*Z.x - sro*Z.y, sro*Z.x + cro*Z.y, Z.z);

            Vector3f RX = new Vector3f(X).mul(hs);
            Vector3f RY = new Vector3f(Y).mul(hs);
            Vector3f RZ = new Vector3f(Z).mul(hs);

            float rr = r, gg = g, bb = b;

            Vector3f C = new Vector3f(cx,cy,cz);
            Vector3f p000 = new Vector3f(C).sub(RX).sub(RY).sub(RZ);
            Vector3f p100 = new Vector3f(C).add(RX).sub(RY).sub(RZ);
            Vector3f p110 = new Vector3f(C).add(RX).add(RY).sub(RZ);
            Vector3f p010 = new Vector3f(C).sub(RX).add(RY).sub(RZ);
            Vector3f p001 = new Vector3f(C).sub(RX).sub(RY).add(RZ);
            Vector3f p101 = new Vector3f(C).add(RX).sub(RY).add(RZ);
            Vector3f p111 = new Vector3f(C).add(RX).add(RY).add(RZ);
            Vector3f p011 = new Vector3f(C).sub(RX).add(RY).add(RZ);

            putQuad(m4, ms, vc, rr,gg,bb,a, 0,1,1,0, p100,p101,p111,p110, X);
            putQuad(m4, ms, vc, rr,gg,bb,a, 0,1,1,0, p000,p010,p011,p001, new Vector3f(X).negate());
            putQuad(m4, ms, vc, rr,gg,bb,a, 0,1,1,0, p010,p110,p111,p011, Y);
            putQuad(m4, ms, vc, rr,gg,bb,a, 0,1,1,0, p000,p001,p101,p100, new Vector3f(Y).negate());
            putQuad(m4, ms, vc, rr,gg,bb,a, 0,1,1,0, p101,p001,p011,p111, Z);
            putQuad(m4, ms, vc, rr,gg,bb,a, 0,1,1,0, p100,p110,p010,p000, new Vector3f(Z).negate());
        }
    }

    private void putQuad(Matrix4f m4, class_4587 ms, class_4588 vc,
                         float r, float g, float b, float a,
                         float u0, float v1, float u1, float v0,
                         Vector3f P0, Vector3f P1, Vector3f P2, Vector3f P3, Vector3f N) {
        int nx = (int)Math.signum(N.x()); int ny = (int)Math.signum(N.y()); int nz = (int)Math.signum(N.z());
        vc.method_22918(m4, P0.x, P0.y, P0.z).method_22915(r,g,b,a).method_22913(u0, v1).method_22922(OVERLAY).method_60803(FULL_BRIGHT).method_60831(ms.method_23760(), nx, ny, nz);
        vc.method_22918(m4, P1.x, P1.y, P1.z).method_22915(r,g,b,a).method_22913(u1, v1).method_22922(OVERLAY).method_60803(FULL_BRIGHT).method_60831(ms.method_23760(), nx, ny, nz);
        vc.method_22918(m4, P2.x, P2.y, P2.z).method_22915(r,g,b,a).method_22913(u1, v0).method_22922(OVERLAY).method_60803(FULL_BRIGHT).method_60831(ms.method_23760(), nx, ny, nz);
        vc.method_22918(m4, P3.x, P3.y, P3.z).method_22915(r,g,b,a).method_22913(u0, v0).method_22922(OVERLAY).method_60803(FULL_BRIGHT).method_60831(ms.method_23760(), nx, ny, nz);
    }
}
