package net.kronoz.odyssey.systems.physics.dust;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import java.util.Map;

public enum DustManager {
    INSTANCE;

    private static final class_2960 WHITE = class_2960.method_60655("minecraft","textures/misc/white.png");

    private static final class Key {
        final String dim; final class_2338 pos;
        Key(String d, class_2338 p){ this.dim=d; this.pos=p.method_10062(); }
        @Override public boolean equals(Object o){ return o instanceof Key k && k.dim.equals(dim) && k.pos.equals(pos); }
        @Override public int hashCode(){ return dim.hashCode()*31 + pos.hashCode(); }
    }
    private static final class Entry {
        final Key key; final DustField field;
        class_243 origin; long lastSeenTime;
        Entry(Key k, DustField f, class_243 o){ key=k; field=f; origin=o; lastSeenTime=0L; }
    }

    private final Map<Key, Entry> entries = new Object2ObjectOpenHashMap<>();
    private static final long KEEP_ALIVE_TICKS = 200L;

    public void installHooks() {
        ClientTickEvents.END_CLIENT_TICK.register(mc -> {
            if (mc == null || mc.field_1687 == null) return;
            var world = mc.field_1687;
            long t = world.method_8510();

            String dimKey = world.method_27983().method_29177().toString();
            entries.values().removeIf(e -> {
                if (!e.key.dim.equals(dimKey)) return false;
                long idle = t - e.lastSeenTime;
                if (idle > KEEP_ALIVE_TICKS) return true;
                double dt = 1.0/20.0;
                e.field.update(dt, e.origin, world, t);
                return false;
            });
        });

        WorldRenderEvents.AFTER_ENTITIES.register(ctx -> {
            class_4587 ms = ctx.matrixStack();
            class_4597 vcp = ctx.consumers();
            float tickDelta = ctx.camera().method_55437();

            var mc = class_310.method_1551();
            if (mc == null || mc.field_1687 == null) return;
            String dimKey = mc.field_1687.method_27983().method_29177().toString();

            var cam = ctx.camera().method_19326();
            ms.method_22903();
            ms.method_22904(-cam.field_1352, -cam.field_1351, -cam.field_1350);

            class_4588 vc = vcp.getBuffer(class_1921.method_23580(WHITE));
            for (Entry e : entries.values()) {
                if (!e.key.dim.equals(dimKey)) continue;
                e.field.render(ms, vc, class_243.field_1353, tickDelta, mc.field_1687);
            }

            ms.method_22909();
        });
    }

    public void pingLightDust(net.minecraft.class_1937 world, class_2338 pos, class_243 origin,
                              int r, int g, int b,
                              int capacity, double emitRatePerSec) {
        String dimKey = world.method_27983().method_29177().toString();
        Key k = new Key(dimKey, pos);
        Entry e = entries.get(k);
        if (e == null) {
            DustField f = new DustField(capacity, r, g, b, emitRatePerSec);
            e = new Entry(k, f, origin);
            entries.put(k, e);
        } else {
            e.origin = origin;
        }
        e.lastSeenTime = world.method_8510();
    }
}
