package net.kronoz.odyssey.systems.physics.jetpack;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;

public final class JetpackExhaustManager {

    private static final class_2960 WHITE = class_2960.method_60655("minecraft", "textures/misc/white.png");

    // sim cadence
    private static final double MAX_FPS = 120.0;
    private static final long   MIN_STEP_NS = (long)(1_000_000_000L / MAX_FPS);

    // when to delete an emitter if nobody pings it and no particles remain
    private static final long EMITTER_IDLE_NS = 1_000_000_000L; // ~1s

    private static final class Emitter {
        final OdysseySmokeField field = new OdysseySmokeField(240, 186, 186, 186);
        class_243 origin = class_243.field_1353;

        long lastTickNs = 0L;
        long lastPingNs = 0L;
        boolean pingedThisFrame = false;

        Emitter() {
            field.setEmitting(true);
        }

        void ping(class_243 o) {
            origin = o;
            pingedThisFrame = true;
            lastPingNs = System.nanoTime();
            field.setEmitting(true);
        }
    }

    private static final Map<String, Emitter> EMITTERS = new HashMap<>();

    /** Called by the renderer once per frame for EACH booster bone it draws. */
    public static void emit(String stableId, class_243 originWS) {
        Emitter e = EMITTERS.computeIfAbsent(stableId, k -> new Emitter());
        e.ping(originWS);
    }

    /** Step all emitters (hook from END_CLIENT_TICK). */
    public static void tick(class_310 mc) {
        if (mc == null || mc.field_1687 == null) return;

        long now = System.nanoTime();

        Iterator<Map.Entry<String, Emitter>> it = EMITTERS.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Emitter> entry = it.next();
            Emitter e = entry.getValue();

            if (e.lastTickNs == 0L) e.lastTickNs = now;

            long elapsed = now - e.lastTickNs;
            if (elapsed >= MIN_STEP_NS) {
                double dt = Math.min(elapsed / 1_000_000_000.0, 1.0 / 20.0);

                if (!e.pingedThisFrame) e.field.setEmitting(false); // no ping → stop spawning, keep sim
                e.field.update(dt, e.origin, mc.field_1687, mc.field_1687.method_8510());

                e.lastTickNs = now;
                e.pingedThisFrame = false;
            }

            // prune if idle and empty
            if ((now - e.lastPingNs) > EMITTER_IDLE_NS && e.field.isEmpty()) {
                it.remove();
            }
        }
    }

    /** Draw all fields (hook from WorldRenderEvents.AFTER_ENTITIES). */
    public static void renderAll(class_4587 ms, class_4597 vcp, float tickDelta) {
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1687 == null) return;

        class_243 cam = mc.field_1773.method_19418().method_19326();
        class_4588 vc = vcp.getBuffer(class_1921.method_23580(WHITE));

        for (Emitter e : EMITTERS.values()) {
            ms.method_22903();
            e.field.render(ms, vc, cam, tickDelta);
            ms.method_22909();
        }
    }
}
