package net.kronoz.odyssey.systems.physics.jetpack;

import org.joml.Matrix4f;
import org.joml.Vector3f;

import java.util.Random;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;

public final class JetpackSmokeField {
    private static final int FULL_BRIGHT = 0x00F000F0;
    private static final int OVERLAY = class_4608.field_21444;
    private static final double CURL_EPS = 0.25;
    private static final double SAMPLE_STEP = 0.10;

    private final Random rng = new Random(0xA77F_5EEDL);

    public static final class Settings {
        public int capacity = 900;
        public double emitPerSecond = 480.0;
        public double lifeMin = 0.8, lifeMax = 2.0;
        public double sizeMin = 0.045, sizeMax = 0.085;
        public double speedMin = 0.9, speedMax = 2.2;
        public double drag = 0.92;
        public double lateralVisc = 0.96;
        public double curlForce = 1.35;
        public double gravity = -0.02;
        public double rise = 0.22;
        public double linger = 1.3;
        public double collideSlide = 0.75;
        public double coneAngleRad = Math.toRadians(16);
        public double spawnJitter = 0.04;
        public double worldRadius = 48.0;
        public double lodCull = 96.0;
    }

    public final Settings cfg;
    private final Node[] nodes;
    private int alive = 0, nextDead = 0;
    private double emitAcc = 0.0;

    private static final class Node {
        boolean alive;
        class_243 p, v;
        float yaw, pitch, roll;
        float yawVel, pitchVel, rollVel;
        double age, life, size;
        // color over life computed on render
        static Node dead(){ Node n=new Node(); n.alive=false; n.p=class_243.field_1353; n.v=class_243.field_1353; return n; }
    }

    public JetpackSmokeField(Settings s) {
        this.cfg = s;
        this.nodes = new Node[s.capacity];
        for (int i=0;i<s.capacity;i++) nodes[i]=Node.dead();
    }

    public void burst(double particles, class_243 pos, class_243 dir) {
        emitAcc += particles;
        while (emitAcc >= 1.0 && alive < nodes.length) {
            int start = nextDead;
            do {
                Node n = nodes[nextDead];
                if (!n.alive) {
                    spawnInto(n, pos, dir);
                    alive++; emitAcc -= 1.0;
                    nextDead = (nextDead + 1) % nodes.length;
                    break;
                }
                nextDead = (nextDead + 1) % nodes.length;
            } while (nextDead != start);
            if (start == nextDead) break;
        }
    }

    private void spawnInto(Node n, class_243 origin, class_243 dir) {
        class_243 jetDir = sampleCone(dir.method_1029(), cfg.coneAngleRad);
        class_243 jitter = new class_243(
                (rng.nextDouble()*2-1)*cfg.spawnJitter,
                (rng.nextDouble()*2-1)*cfg.spawnJitter,
                (rng.nextDouble()*2-1)*cfg.spawnJitter
        );
        n.p = origin.method_1019(jitter);

        double sp = cfg.speedMin + rng.nextDouble()*(cfg.speedMax - cfg.speedMin);
        n.v = jetDir.method_1021(sp);

        n.life = cfg.lifeMin + rng.nextDouble()*(cfg.lifeMax - cfg.lifeMin);
        n.age = 0.0;
        n.size = cfg.sizeMin + rng.nextDouble()*(cfg.sizeMax - cfg.sizeMin);

        n.yaw   = (float)(rng.nextDouble()*Math.PI*2);
        n.pitch = (float)((rng.nextDouble()-0.5)*0.6);
        n.roll  = (float)((rng.nextDouble()-0.5)*0.6);
        n.yawVel   = (float)((rng.nextDouble()-0.5)*3.0);
        n.pitchVel = (float)((rng.nextDouble()-0.5)*3.0);
        n.rollVel  = (float)((rng.nextDouble()-0.5)*3.0);

        n.alive = true;
    }

    public void update(double dt, class_1937 world, long time, class_243 attractUp) {
        if (dt <= 0) return;

        double t = time * 0.02;
        for (int i=0;i<nodes.length;i++) {
            Node n = nodes[i];
            if (!n.alive) continue;

            n.age += dt;
            if (n.age >= n.life * cfg.linger) { n.alive=false; alive--; continue; }
            if (n.p.method_1025(class_243.field_1353) > cfg.worldRadius*cfg.worldRadius*16) { n.alive=false; alive--; continue; }

            class_243 curl = curl3(
                    n.p.field_1352*0.45 + t*0.09 + i*0.0017,
                    n.p.field_1351*0.45 + t*0.09 + i*0.0021,
                    n.p.field_1350*0.45 + t*0.09 + i*0.0013
            ).method_1021(cfg.curlForce);

            class_243 up = attractUp.method_1021(cfg.rise);
            class_243 g = new class_243(0, cfg.gravity, 0);

            n.v = n.v.method_1019(curl.method_1021(dt)).method_1019(up.method_1021(dt)).method_1019(g.method_1021(dt));
            n.v = new class_243(n.v.field_1352*cfg.lateralVisc, n.v.field_1351*cfg.drag, n.v.field_1350*cfg.lateralVisc);

            class_243 next = n.p.method_1019(n.v.method_1021(dt));
            n.p = collideWorld(n.p, next, world);

            n.yaw += n.yawVel*dt;   n.yawVel   *= 0.98;
            n.pitch += n.pitchVel*dt; n.pitchVel *= 0.98;
            n.roll += n.rollVel*dt;  n.rollVel  *= 0.98;
        }
    }

    public void render(class_4587 ms, class_4588 vc, class_243 camBase, float tickDelta, class_1937 world) {
        Matrix4f m4 = ms.method_23760().method_23761();

        for (Node n : nodes) {
            if (!n.alive) continue;
            if (camBase.method_1025(n.p) > cfg.lodCull*cfg.lodCull) continue;

            double lt = class_3532.method_15350(n.age / n.life, 0.0, cfg.linger);
            float a = alphaOverLife((float)lt);
            if (a < 0.01f) continue;

            float hs = (float)n.size * 0.5f;

            float cx = (float)(n.p.field_1352 - camBase.field_1352);
            float cy = (float)(n.p.field_1351 - camBase.field_1351);
            float cz = (float)(n.p.field_1350 - camBase.field_1350);

            float cyw = (float)Math.cos(n.yaw), syw = (float)Math.sin(n.yaw);
            float cpi = (float)Math.cos(n.pitch), spi = (float)Math.sin(n.pitch);
            float cro = (float)Math.cos(n.roll),  sro = (float)Math.sin(n.roll);

            Vector3f X = new Vector3f(1,0,0);
            Vector3f Y = new Vector3f(0,1,0);
            Vector3f Z = new Vector3f(0,0,1);

            X = new Vector3f(cyw*X.x - syw*X.z, X.y, syw*X.x + cyw*X.z);
            Y = new Vector3f(cyw*Y.x - syw*Y.z, Y.y, syw*Y.x + cyw*Y.z);
            Z = new Vector3f(cyw*Z.x - syw*Z.z, Z.y, syw*Z.x + cyw*Z.z);

            X = new Vector3f(X.x,  cpi*X.y - spi*X.z,  spi*X.y + cpi*X.z);
            Y = new Vector3f(Y.x,  cpi*Y.y - spi*Y.z,  spi*Y.y + cpi*Y.z);
            Z = new Vector3f(Z.x,  cpi*Z.y - spi*Z.z,  spi*Z.y + cpi*Z.z);

            X = new Vector3f( cro*X.x - sro*X.y, sro*X.x + cro*X.y, X.z);
            Y = new Vector3f( cro*Y.x - sro*Y.y, sro*Y.x + cro*Y.y, Y.z);
            Z = new Vector3f( cro*Z.x - sro*Z.y, sro*Z.x + cro*Z.y, Z.z);

            Vector3f RX = new Vector3f(X).mul(hs);
            Vector3f RY = new Vector3f(Y).mul(hs);
            Vector3f RZ = new Vector3f(Z).mul(hs);

            float[] col = colorOverLife((float)lt);
            float r = col[0], g = col[1], b = col[2];

            Vector3f C = new Vector3f(cx,cy,cz);
            Vector3f p000 = new Vector3f(C).sub(RX).sub(RY).sub(RZ);
            Vector3f p100 = new Vector3f(C).add(RX).sub(RY).sub(RZ);
            Vector3f p110 = new Vector3f(C).add(RX).add(RY).sub(RZ);
            Vector3f p010 = new Vector3f(C).sub(RX).add(RY).sub(RZ);
            Vector3f p001 = new Vector3f(C).sub(RX).sub(RY).add(RZ);
            Vector3f p101 = new Vector3f(C).add(RX).sub(RY).add(RZ);
            Vector3f p111 = new Vector3f(C).add(RX).add(RY).add(RZ);
            Vector3f p011 = new Vector3f(C).sub(RX).add(RY).add(RZ);

            putQuad(m4, ms, vc, r,g,b,a, 0,1,1,0, p100,p101,p111,p110, X);
            putQuad(m4, ms, vc, r,g,b,a, 0,1,1,0, p000,p010,p011,p001, new Vector3f(X).negate());
            putQuad(m4, ms, vc, r,g,b,a, 0,1,1,0, p010,p110,p111,p011, Y);
            putQuad(m4, ms, vc, r,g,b,a, 0,1,1,0, p000,p001,p101,p100, new Vector3f(Y).negate());
            putQuad(m4, ms, vc, r,g,b,a, 0,1,1,0, p101,p001,p011,p111, Z);
            putQuad(m4, ms, vc, r,g,b,a, 0,1,1,0, p100,p110,p010,p000, new Vector3f(Z).negate());
        }
    }

    private static float smooth(float t){ return t*t*(3f-2f*t); }
    private static float clamp01(float v){ return v<0?0:Math.min(1,v); }

    private static float[] colorOverLife(float t) {
        float len = 1.0f;
        float k0 = clamp01(t / 0.15f);                 // flame → plasma
        float k1 = clamp01((t-0.15f) / (0.50f-0.15f)); // plasma → smoke
        float k2 = clamp01((t-0.50f) / (len-0.50f));   // smoke fade

        float r0=1.00f, g0=0.78f, b0=0.15f; // yellow/orange
        float r1=0.60f, g1=0.25f, b1=0.90f; // purple
        float r2=0.62f, g2=0.62f, b2=0.62f; // grey

        float rA = r0 + (r1-r0)*smooth(k1);
        float gA = g0 + (g1-g0)*smooth(k1);
        float bA = b0 + (b1-b0)*smooth(k1);

        float r = rA + (r2-rA)*smooth(k2);
        float g = gA + (g2-gA)*smooth(k2);
        float b = bA + (b2-bA)*smooth(k2);
        return new float[]{r,g,b};
    }

    private static float alphaOverLife(float t) {
        float rise = clamp01(t / 0.12f);
        float fade = clamp01(1.0f - (float)Math.pow(Math.max(0, t-0.5f) / 0.5f, 1.1));
        return 0.10f + 0.90f * rise * fade;
    }

    private void putQuad(Matrix4f m4, class_4587 ms, class_4588 vc,
                         float r, float g, float b, float a,
                         float u0, float v1, float u1, float v0,
                         Vector3f P0, Vector3f P1, Vector3f P2, Vector3f P3, Vector3f N) {
        int nx = (int)Math.signum(N.x()); int ny = (int)Math.signum(N.y()); int nz = (int)Math.signum(N.z());
        vc.method_22918(m4, P0.x, P0.y, P0.z).method_22915(r,g,b,a).method_22913(u0, v1).method_22922(OVERLAY).method_60803(FULL_BRIGHT).method_60831(ms.method_23760(), nx, ny, nz);
        vc.method_22918(m4, P1.x, P1.y, P1.z).method_22915(r,g,b,a).method_22913(u1, v1).method_22922(OVERLAY).method_60803(FULL_BRIGHT).method_60831(ms.method_23760(), nx, ny, nz);
        vc.method_22918(m4, P2.x, P2.y, P2.z).method_22915(r,g,b,a).method_22913(u1, v0).method_22922(OVERLAY).method_60803(FULL_BRIGHT).method_60831(ms.method_23760(), nx, ny, nz);
        vc.method_22918(m4, P3.x, P3.y, P3.z).method_22915(r,g,b,a).method_22913(u0, v0).method_22922(OVERLAY).method_60803(FULL_BRIGHT).method_60831(ms.method_23760(), nx, ny, nz);
    }

    private class_243 collideWorld(class_243 cur, class_243 next, class_1937 world) {
        class_243 delta = next.method_1020(cur);
        int steps = Math.max(1, (int)Math.ceil(delta.method_1033() / SAMPLE_STEP));
        class_243 p = cur;

        for (int i = 1; i <= steps; i++) {
            double t = (double)i / (double)steps;
            class_243 probe = cur.method_35590(next, t);
            class_2338 bp = class_2338.method_49638(probe);
            if (!world.method_22340(bp)) { p = probe; continue; }
            class_2680 st = world.method_8320(bp);
            if (!st.method_26215()) {
                class_265 sh = st.method_26220(world, bp);
                if (!sh.method_1110()) {
                    class_243 back = cur.method_35590(next, Math.max(0, t - 0.10));
                    class_2350 face = nearestFace(probe, bp);
                    class_243 nrm = new class_243(face.method_23955().x(), face.method_23955().y(), face.method_23955().z());
                    class_243 slide = projectOntoPlane(next.method_1020(back), nrm).method_1021(cfg.collideSlide);
                    return back.method_1019(slide).method_1019(nrm.method_1021(0.008));
                }
            }
            p = probe;
        }
        return p;
    }

    private static class_243 projectOntoPlane(class_243 v, class_243 n) {
        double dot = v.field_1352*n.field_1352 + v.field_1351*n.field_1351 + v.field_1350*n.field_1350;
        return new class_243(v.field_1352 - dot*n.field_1352, v.field_1351 - dot*n.field_1351, v.field_1350 - dot*n.field_1350);
    }
    private static class_2350 nearestFace(class_243 p, class_2338 bp) {
        double cx = bp.method_10263()+0.5, cy = bp.method_10264()+0.5, cz = bp.method_10260()+0.5;
        double dx = p.field_1352-cx, dy = p.field_1351-cy, dz = p.field_1350-cz;
        double ax=Math.abs(dx), ay=Math.abs(dy), az=Math.abs(dz);
        if (ay >= ax && ay >= az) return dy>0?class_2350.field_11036:class_2350.field_11033;
        if (ax >= az) return dx>0?class_2350.field_11034:class_2350.field_11039;
        return dz>0?class_2350.field_11035:class_2350.field_11043;
    }

    private static class_243 sampleCone(class_243 baseDir, double ang) {
        double u = Math.random(), v = Math.random();
        double theta = 2*Math.PI*u;
        double cosAng = Math.cos(ang);
        double z = cosAng + (1 - cosAng) * v;
        double s = Math.sqrt(Math.max(0, 1 - z*z));
        class_243 local = new class_243(s*Math.cos(theta), z, s*Math.sin(theta));
        class_243 a = Math.abs(baseDir.field_1352) < 0.9 ? new class_243(1,0,0) : new class_243(0,1,0);
        class_243 t1 = baseDir.method_1036(a).method_1029();
        class_243 t2 = t1.method_1036(baseDir).method_1029();
        return t1.method_1021(local.field_1352).method_1019(baseDir.method_1021(local.field_1351)).method_1019(t2.method_1021(local.field_1350)).method_1029();
    }

    private class_243 curl3(double x,double y,double z){
        double e=CURL_EPS;
        double Ny_z1=noise3(x,y,z+e), Ny_z0=noise3(x,y,z-e);
        double Nz_y1=noise3(x,y+e,z), Nz_y0=noise3(x,y-e,z);
        double Nz_x1=noise3(x+e,y,z), Nz_x0=noise3(x-e,y,z);
        double Nx_z1=noise3(x,y,z+e), Nx_z0=noise3(x,y,z-e);
        double Nx_y1=noise3(x,y+e,z), Nx_y0=noise3(x,y-e,z);
        double Ny_x1=noise3(x+e,y,z), Ny_x0=noise3(x-e,y,z);
        double cx=(Nz_y1-Nz_y0)-(Ny_z1-Ny_z0);
        double cy=(Nx_z1-Nx_z0)-(Nz_x1-Nz_x0);
        double cz=(Ny_x1-Ny_x0)-(Nx_y1-Nx_y0);
        double L=Math.sqrt(cx*cx+cy*cy+cz*cz)+1e-9;
        return new class_243(cx/L, cy/L, cz/L);
    }
    private static int fastFloor(double x){ int i=(int)x; return x<i?i-1:i; }
    private static double s(double t){ return t*t*(3-2*t); }
    private static double lerp(double t,double a,double b){ return a + t*(b-a); }
    private static double hash(int x,int y,int z){
        long v=(long)x*374761393L + (long)y*668265263L + (long)z*700001L;
        v=(v^(v>>13))*1274126177L; v^=(v>>16);
        return (v & 0xFFFFFFFFL) / 4294967296.0;
    }
    private double noise3(double x,double y,double z){
        int xi=fastFloor(x), yi=fastFloor(y), zi=fastFloor(z);
        double xf=x-xi, yf=y-yi, zf=z-zi;
        double u=s(xf), v=s(yf), w=s(zf);
        double n000=hash(xi,yi,zi), n100=hash(xi+1,yi,zi);
        double n010=hash(xi,yi+1,zi), n110=hash(xi+1,yi+1,zi);
        double n001=hash(xi,yi,zi+1), n101=hash(xi+1,yi,zi+1);
        double n011=hash(xi,yi+1,zi+1), n111=hash(xi+1,yi+1,zi+1);
        double x00=lerp(u,n000,n100), x10=lerp(u,n010,n110);
        double x01=lerp(u,n001,n101), x11=lerp(u,n011,n111);
        double y0=lerp(v,x00,x10), y1=lerp(v,x01,x11);
        return lerp(w,y0,y1)*2.0-1.0;
    }
}
