package net.kronoz.odyssey.systems.physics.jetpack;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;

public final class JetpackSmokeSystem {

    private static final class_2960 WHITE = class_2960.method_60655("minecraft", "textures/misc/white.png");
    private static final class_1921 LAYER = class_1921.method_23580(WHITE);

    private static final Map<String, Emitter> EMITTERS = new LinkedHashMap<>();

    private static final double MAX_FPS = 120.0;
    private static final long   MIN_STEP_NS = (long)(1_000_000_000L / MAX_FPS);

    private static final double IDLE_TIMEOUT_S = 2.0; // stop emitting after this if not refreshed; field still simulates to death
    private static final double DIE_AFTER_S    = 8.0; // hard cap to cull abandoned emitters once empty

    private JetpackSmokeSystem() {}

    public static void emit(String emitterId, class_243 originWS, class_243 axisWS) {
        long now = System.nanoTime();
        Emitter e = EMITTERS.get(emitterId);
        if (e == null) {
            e = new Emitter();
            // match your current tuned defaults in OdysseySmokeField ctor:
            e.field = new OdysseySmokeField(500); // capacity—adjust if you like
            EMITTERS.put(emitterId, e);
        }
        e.lastEmitWorldPos = originWS;
        e.axisWS = axisWS;
        e.lastSeenNs = now;
        e.emitting = true;
    }

    public static void tick() {
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1687 == null) return;

        long now = System.nanoTime();
        double worldTime = mc.field_1687.method_8510();

        Iterator<Map.Entry<String, Emitter>> it = EMITTERS.entrySet().iterator();
        while (it.hasNext()) {
            Emitter em = it.next().getValue();

            if (em.lastStepNs == 0L) {
                em.lastStepNs = now;
                continue;
            }
            long elapsed = now - em.lastStepNs;
            if (elapsed < MIN_STEP_NS) continue; // fps cap

            double dt = Math.min(elapsed / 1_000_000_000.0, 1.0/20.0);
            em.lastStepNs = now;

            boolean recentlySeen = (now - em.lastSeenNs) < (long)(IDLE_TIMEOUT_S * 1_000_000_000L);
            em.emitting = recentlySeen;

            if (em.emitting && em.lastEmitWorldPos != null && em.axisWS != null) {
                em.field.setEmitting(true);
                em.field.setAxis(em.axisWS); // lets the plume know the thrust direction
                em.field.update(dt, em.lastEmitWorldPos, mc.field_1687, (long)worldTime);
            } else {
                em.field.setEmitting(false);
                // continue sim with last origin so particles finish naturally
                if (em.lastEmitWorldPos != null) {
                    em.field.update(dt, em.lastEmitWorldPos, mc.field_1687, (long)worldTime);
                }
            }

            boolean empty = em.field.isEmpty();
            boolean tooOld = (now - em.lastSeenNs) > (long)(DIE_AFTER_S * 1_000_000_000L);
            if (empty && tooOld) {
                it.remove();
            }
        }
    }

    public static void renderAll(class_4587 ms, class_4597 vcp, float tickDelta) {
        if (EMITTERS.isEmpty()) return;
        class_4588 vc = vcp.getBuffer(LAYER);
        class_243 cam = class_310.method_1551().field_1773.method_19418().method_19326();

        for (Emitter e : EMITTERS.values()) {
            // render in camera-relative coords so nothing follows the camera
            e.field.render(ms, vc, cam, tickDelta);
        }
    }

    private static final class Emitter {
        OdysseySmokeField field;
        class_243 lastEmitWorldPos;
        class_243 axisWS;
        long lastStepNs;
        long lastSeenNs;
        boolean emitting;
    }
}
