package net.kronoz.odyssey.systems.physics.jetpack;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1304;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import java.util.Map;

public final class JetpackSystem {
    public static final JetpackSystem INSTANCE = new JetpackSystem();

    private static final class_2960 WHITE = class_2960.method_60655("minecraft", "textures/misc/white.png");
    private static final String BONE1="booster_1", BONE2="booster_2", BONE3="booster_3";

    public static final class Emitter {
        public final JetpackSmokeField field;
        public class_243 b1 = null, b2 = null, b3 = null;
        public boolean active = false;
        public Emitter() { field = new JetpackSmokeField(new JetpackSmokeField.Settings()); }
    }

    private final Map<Integer, Emitter> byPlayer = new Object2ObjectOpenHashMap<>();

    public void install(class_1792 jetpackItem) {
        ClientTickEvents.END_CLIENT_TICK.register(mc -> {
            if (mc == null || mc.field_1687 == null || mc.field_1724 == null) return;

            var p = mc.field_1724;
            Emitter em = byPlayer.computeIfAbsent(p.method_5628(), k -> new Emitter());

            // check worn
            class_1799 chest = p.method_6118(class_1304.field_6174);
            boolean wearing = chest != null && !chest.method_7960() && chest.method_7909() == jetpackItem;

            // hold jump to thrust
            boolean thrust = wearing && mc.field_1690.field_1903.method_1434();

            em.active = thrust;

            // upward thrust & slight forward control
            if (thrust) {
                class_243 vel = p.method_18798();
                double targetUp = 0.9;
                double add = Math.max(0, targetUp - vel.field_1351);
                p.method_18799(vel.method_1031(0, Math.min(0.12, add), 0));
                p.field_6017 = 0f;
            }

            // compute bone directions/emission
            class_243 up = new class_243(0,1,0);
            double dt = 1.0/20.0;

            if (em.active) {
                class_243 viewBack = p.method_5720().method_1021(-1.0).method_1031(0, -0.5, 0).method_1029();
                // if bones not set externally, fallback to offsets behind chest
                class_243 base = p.method_19538().method_1031(0, p.method_5751()*0.5, 0);
                class_243 right = viewBack.method_1036(up).method_1029();

                class_243 fb1 = em.b1 != null ? em.b1 : base.method_1019(right.method_1021(0.22)).method_1019(viewBack.method_1021(0.25));
                class_243 fb2 = em.b2 != null ? em.b2 : base.method_1019(viewBack.method_1021(0.28));
                class_243 fb3 = em.b3 != null ? em.b3 : base.method_1019(right.method_1021(-0.22)).method_1019(viewBack.method_1021(0.25));

                // emit fast
                double rate = 1.0/20.0; // time slice
                double want = em.field.cfg.emitPerSecond * rate;
                em.field.burst(want/3.0, fb1, viewBack);
                em.field.burst(want/3.0, fb2, viewBack);
                em.field.burst(want/3.0, fb3, viewBack);

                // strong up-attractor to make plume curve upward
                em.field.update(dt, mc.field_1687, mc.field_1687.method_8510(), up);
            } else {
                // still update lingering smoke
                em.field.update(dt, mc.field_1687, mc.field_1687.method_8510(), up.method_1021(0.5));
            }
        });

        WorldRenderEvents.AFTER_ENTITIES.register(ctx -> {
            var mc = class_310.method_1551();
            if (mc == null || mc.field_1687 == null) return;

            class_4587 ms = ctx.matrixStack();
            class_4597 vcp = ctx.consumers();
            class_4588 vc = vcp.getBuffer(class_1921.method_23580(WHITE));
            var cam = ctx.camera().method_19326();
            float tickDelta = ctx.camera().method_55437();

            ms.method_22903();
            ms.method_22904(-cam.field_1352, -cam.field_1351, -cam.field_1350);

            for (Emitter em : byPlayer.values()) {
                em.field.render(ms, vc, class_243.field_1353, tickDelta, mc.field_1687);
            }

            ms.method_22909();
        });
    }

    // Call this from your model renderer/anim callback each frame to provide bone world positions.
    public void setBoneWorldPos(int playerId, String boneName, class_243 worldPos) {
        Emitter em = byPlayer.get(playerId);
        if (em == null) return;
        if (BONE1.equals(boneName)) em.b1 = worldPos;
        else if (BONE2.equals(boneName)) em.b2 = worldPos;
        else if (BONE3.equals(boneName)) em.b3 = worldPos;
    }
}
