package net.kronoz.odyssey.systems.physics.wire;

import org.joml.Matrix4f;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;

public final class WireManager {
    private WireManager(){}

    private static final Map<UUID, WireSim> SIMS = new HashMap<>();
    private static final Map<UUID, WireDef> DEFS = new HashMap<>();

    public static void ensure(UUID id, WireDef def, class_243 a, class_243 b){
        if (!SIMS.containsKey(id)) {
            SIMS.put(id, new WireSim(def, a, b, def.halfWidth));
            DEFS.put(id, def);
        }
    }

    public static WireSim get(UUID id){ return SIMS.get(id); }
    public static WireDef getDef(UUID id){ return DEFS.get(id); }
    public static void remove(UUID id){ SIMS.remove(id); DEFS.remove(id); }
    public static void clearAllClient(){ SIMS.clear(); DEFS.clear(); }

    public static void ensureFromRecordClient(WireRecord r){
        WireDef def = WireDef.defaultCable(r.defId);
        class_243 a = WireToolMath.anchorCenter(r.a);
        class_243 b = WireToolMath.anchorCenter(r.b);
        ensure(r.id, def, a, b);
        WireSim sim = get(r.id);
        if (sim != null) sim.setPinned(r.aPinned, r.bPinned);
    }

    public static void stepAndRender(UUID id,
                                     class_243 a, boolean aPinned,
                                     class_243 b, boolean bPinned,
                                     class_4587 matrices,
                                     class_4597 consumers,
                                     int light, int overlay) {
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1687 == null) return;

        WireSim sim = SIMS.get(id);
        WireDef def = DEFS.get(id);
        if (sim == null || def == null) return;

        sim.setPinned(aPinned, bPinned);
        sim.step(mc.field_1687, a, b);

        class_243 cam = mc.field_1773.method_19418().method_19326();
        class_4587 ms = new class_4587();
        ms.method_22904(-cam.field_1352, -cam.field_1351, -cam.field_1350);
        class_4587.class_4665 entry = ms.method_23760();
        Matrix4f pm = entry.method_23761();

        class_4588 vc = consumers.getBuffer(class_1921.method_23578(def.texture));
        renderTubeQuadPanels(def, sim, vc, pm, entry, light, overlay);
    }

    private static void renderTubeQuadPanels(WireDef def, WireSim sim,
                                             class_4588 vc, Matrix4f pm, class_4587.class_4665 entry,
                                             int light, int overlay) {
        WireSim.Node[] ns = sim.nodes();
        if (ns.length < 2) return;

        final int sides = Math.max(3, def.tubeSides);
        final float r   = def.halfWidth;
        final int LIGHT = 0x00F000F0;

        class_243[] T = new class_243[ns.length];
        for (int i=0;i<ns.length;i++){
            class_243 t = (i==0)? ns[1].p.method_1020(ns[0].p)
                    : (i==ns.length-1)? ns[i].p.method_1020(ns[i-1].p)
                    : ns[i+1].p.method_1020(ns[i-1].p);
            double L=t.method_1033();
            T[i] = (L<1e-9)? new class_243(0,1,0) : t.method_1021(1.0/L);
        }

        class_243[] N = new class_243[ns.length];
        class_243[] B = new class_243[ns.length];
        {
            class_243 t0 = T[0];
            class_243 helper = Math.abs(t0.field_1351) > 0.92 ? new class_243(1,0,0) : new class_243(0,1,0);
            class_243 n0 = helper.method_1036(t0);
            double L = n0.method_1033(); n0 = (L<1e-9)? new class_243(0,0,1) : n0.method_1021(1.0/L);
            class_243 b0 = t0.method_1036(n0);
            N[0]=n0; B[0]=b0;
            for (int i=1;i<ns.length;i++){
                class_243 ti=T[i];
                double dot = N[i-1].method_1026(ti);
                class_243 nProj = N[i-1].method_1020(ti.method_1021(dot));
                double Ln=nProj.method_1033();
                class_243 ni = (Ln<1e-9)? N[i-1] : nProj.method_1021(1.0/Ln);
                class_243 bi = ti.method_1036(ni);
                N[i]=ni; B[i]=bi;
            }
        }

        class_243[][] P = new class_243[ns.length][sides];
        for (int i=0;i<ns.length;i++){
            for (int k=0;k<sides;k++){
                double a = (2*Math.PI * k) / sides;
                double ca=Math.cos(a), sa=Math.sin(a);
                class_243 n = N[i].method_1021(ca).method_1019(B[i].method_1021(sa));
                P[i][k] = ns[i].p.method_1019(n.method_1021(r));
            }
        }

        float invU = 1f / Math.max(1, ns.length-1);
        float invV = 1f / sides;

        for (int i=0;i<ns.length-1;i++){
            float u0 = i * invU, u1 = (i+1) * invU;
            for (int k=0;k<sides;k++){
                int k1 = (k+1) % sides;

                class_243 a = P[i][k];
                class_243 b = P[i][k1];
                class_243 c = P[i+1][k1];
                class_243 d = P[i+1][k];

                class_243 e1 = b.method_1020(a);
                class_243 e2 = d.method_1020(a);
                class_243 n  = e1.method_1036(e2);
                double Ln = n.method_1033();
                if (Ln < 1e-9) n = new class_243(0,1,0);
                else n = n.method_1021(1.0/Ln);

                float v0 = k * invV, v1 = (k+1) * invV;

                put(vc, pm, entry, a, u0, v0, n, overlay, LIGHT);
                put(vc, pm, entry, b, u0, v1, n, overlay, LIGHT);
                put(vc, pm, entry, c, u1, v1, n, overlay, LIGHT);

                put(vc, pm, entry, a, u0, v0, n, overlay, LIGHT);
                put(vc, pm, entry, c, u1, v1, n, overlay, LIGHT);
                put(vc, pm, entry, d, u1, v0, n, overlay, LIGHT);

                put(vc, pm, entry, a, u0, v0, n, overlay, LIGHT);
                put(vc, pm, entry, b, u0, v1, n, overlay, LIGHT);
                put(vc, pm, entry, d, u1, v0, n, overlay, LIGHT);

                put(vc, pm, entry, b, u0, v1, n, overlay, LIGHT);
                put(vc, pm, entry, c, u1, v1, n, overlay, LIGHT);
                put(vc, pm, entry, d, u1, v0, n, overlay, LIGHT);
            }
        }
    }

    private static void put(class_4588 vc, Matrix4f pm, class_4587.class_4665 entry,
                            class_243 p, float u, float v, class_243 n, int overlay, int light){
        vc.method_22918(pm,(float)p.field_1352,(float)p.field_1351,(float)p.field_1350);
        vc.method_22915(1f,1f,1f,1f);
        vc.method_22913(u,v);
        vc.method_22922(overlay);
        vc.method_60803(light);
        vc.method_60831(entry,(float)n.field_1352,(float)n.field_1351,(float)n.field_1350);
    }
}