package net.kronoz.odyssey.systems.physics.wire;

import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_3726;

public final class WireSim {
    public static final class Node {
        public class_243 p, prev;
        public float invM;
        Node(class_243 v, float inv){ p=v; prev=v; invM=inv; }
    }
    private final double halfWidth;

    private final WireDef def;
    private final Node[] nodes;
    private double targetLen;
    private boolean pinStart = true, pinEnd = true;

    private static final double CONTACT_SLOP=0.0015, BAUMGARTE=0.34, DYN_FRICTION=0.30;

    public WireSim(WireDef def, class_243 a, class_243 b, double halfWidth) {
        this.def = def;
        this.nodes = new Node[def.segments + 1];
        for (int i=0;i<nodes.length;i++){
            double t = (double)i/(nodes.length-1);
            nodes[i] = new Node(a.method_35590(b, t), 1f);
        }
        setEndpoints(a,b);
        final double MIN_SCALE = 0.65;
        double scale = MIN_SCALE + (1.0 - MIN_SCALE) * Math.random();
        this.halfWidth = Math.max(1e-6, def.halfWidth * scale);
    }

    public void setPinned(boolean startPinned, boolean endPinned){
        this.pinStart = startPinned;
        this.pinEnd   = endPinned;
        nodes[0].invM = startPinned ? 0f : 1f;
        nodes[nodes.length-1].invM = endPinned ? 0f : 1f;
    }
    public double getHalfWidth() {
        return halfWidth;
    }
    public void setEndpoints(class_243 a, class_243 b){
        double base = Math.max(1e-5, a.method_1022(b));
        double slack = def.baseSlack + def.sagPerMeter * base;
        this.targetLen = base * (1.0 + slack);
        if (pinStart){ nodes[0].p=a; nodes[0].prev=a; }
        if (pinEnd){ int i=nodes.length-1; nodes[i].p=b; nodes[i].prev=b; }
    }

    public Node[] nodes(){ return nodes; }

    public void step(class_1937 world, class_243 a, class_243 b){
        setEndpoints(a,b);

        double maxMove = 0.0;
        for (Node n : nodes) {
            double L2 = n.p.method_1020(n.prev).method_1027();
            if (L2 > maxMove) maxMove = L2;
        }
        double move = Math.sqrt(maxMove);
        int extra = move > (def.halfWidth * 0.6) ? 2 : 0;
        int totalSub = Math.min(6, def.substeps + extra);
        float h = 1.0f / totalSub;

        for (int s=0; s<totalSub; s++){
            integrate(h);
            for (int k=0;k<def.iters;k++){
                distanceConstraints();
                lengthConstraint();
                bendSmoothing(def.bendK);
                if (pinStart){ nodes[0].p=a; }
                if (pinEnd){ nodes[nodes.length-1].p=b; }
            }
            collideBlocks(world);
        }
    }

    private void integrate(float dt){
        final double g = def.gravity * dt * dt;
        final double damp = Math.min(0.98, def.damping);
        for (Node n : nodes){
            if (n.invM == 0f) continue;
            class_243 cur = n.p;
            class_243 v = cur.method_1020(n.prev).method_1021(1.0 - damp);
            n.prev = cur;
            n.p = cur.method_1031(v.field_1352, v.field_1351 - g, v.field_1350);
        }
    }

    private void distanceConstraints(){
        double segLen = targetLen / (nodes.length-1);
        for (int i=0;i<nodes.length-1;i++){
            Node a = nodes[i], b = nodes[i+1];
            class_243 d = b.p.method_1020(a.p);
            double L = d.method_1033(); if (L<=1e-9) continue;
            double diff = (L - segLen)/L;
            float wa=a.invM, wb=b.invM; float ws=wa+wb; if (ws==0f) continue;
            class_243 corr = d.method_1021(0.5*diff);
            if (wa>0) a.p = a.p.method_1019(corr.method_1021(+wa/ws*2));
            if (wb>0) b.p = b.p.method_1019(corr.method_1021(-wb/ws*2));
        }
    }

    private void lengthConstraint(){
        double total=0.0;
        for (int i=0;i<nodes.length-1;i++) total += nodes[i].p.method_1022(nodes[i+1].p);
        if (total<1e-9) return;
        double scale = targetLen/total;
        if (Math.abs(scale-1.0)<1e-6) return;
        class_243 s=nodes[0].p, e=nodes[nodes.length-1].p;
        for (int i=1;i<nodes.length-1;i++){
            Node n = nodes[i]; if (n.invM==0f) continue;
            double t=(double)i/(nodes.length-1);
            class_243 tgt=s.method_35590(e,t);
            class_243 cur=n.p;
            n.p = tgt.method_1019(cur.method_1020(tgt).method_1021(scale));
        }
    }

    private void bendSmoothing(float k){
        if (k <= 0f) return;
        for (int i=1;i<nodes.length-1;i++){
            Node a=nodes[i-1], b=nodes[i], c=nodes[i+1];
            if (b.invM == 0f) continue;
            class_243 mid = a.p.method_1019(c.p).method_1021(0.5);
            b.p = b.p.method_1021(1.0 - k).method_1019(mid.method_1021(k));
        }
    }

    private void collideBlocks(class_1937 world){
        if (world==null) return;
        final double r = Math.max(0.008, def.halfWidth * 0.95);

        for (int pass=0; pass<def.collidePasses; pass++) {
            for (Node n : nodes){
                if (n.invM==0f) continue;
                class_2338 base = class_2338.method_49638(n.p);

                for (int by=-1; by<=1; by++)
                    for (int bx=-1; bx<=1; bx++)
                        for (int bz=-1; bz<=1; bz++){
                            class_2338 p = base.method_10069(bx,by,bz);
                            var state = world.method_8320(p);
                            if (state.method_26215()) continue;

                            class_265 shape = state.method_26194(world, p, class_3726.method_16194());
                            if (shape.method_1110()) continue;

                            iterateShapeBoxes(shape, p, (ax0,ay0,az0, ax1,ay1,az1) ->
                                    resolve(n, ax0,ay0,az0, ax1,ay1,az1, r));
                        }
            }
        }
    }

    @FunctionalInterface
    private interface BoxConsumer {
        void accept(double minX,double minY,double minZ,double maxX,double maxY,double maxZ);
    }

    private static void iterateShapeBoxes(class_265 shape, class_2338 pos, BoxConsumer consumer){
        boolean success = false;
        try {
            shape.method_1089((x0, y0, z0, x1, y1, z1) -> consumer.accept(
                    pos.method_10263()+x0, pos.method_10264()+y0, pos.method_10260()+z0,
                    pos.method_10263()+x1, pos.method_10264()+y1, pos.method_10260()+z1
            ));
            success = true;
        } catch (Throwable ignored) {}

        if (!success) {
            try {
                for (class_238 local : shape.method_1090()) {
                    class_238 bb = local.method_996(pos);
                    consumer.accept(bb.field_1323, bb.field_1322, bb.field_1321, bb.field_1320, bb.field_1325, bb.field_1324);
                }
            } catch (Throwable ignoredEvenMore) {}
        }
    }

    private void resolve(Node n,double ax0,double ay0,double az0,double ax1,double ay1,double az1,double r){
        double cx=clamp(n.p.field_1352,ax0,ax1), cy=clamp(n.p.field_1351,ay0,ay1), cz=clamp(n.p.field_1350,az0,az1);
        double nx=n.p.field_1352-cx, ny=n.p.field_1351-cy, nz=n.p.field_1350-cz;
        double d2=nx*nx+ny*ny+nz*nz;

        boolean embedded = (n.p.field_1352 > ax0 && n.p.field_1352 < ax1 &&
                n.p.field_1351 > ay0 && n.p.field_1351 < ay1 &&
                n.p.field_1350 > az0 && n.p.field_1350 < az1);

        if (d2 < 1e-12) {
            nx = 0; ny = 1; nz = 0;
            d2 = 1.0;
        }

        double dist=Math.sqrt(d2);
        if (dist >= r && !embedded) return;

        double nmx=nx/dist, nmy=ny/dist, nmz=nz/dist;

        double pen = embedded ? r : (r - dist);
        if (pen <= CONTACT_SLOP) return;

        double corr = BAUMGARTE * (pen - CONTACT_SLOP);
        if (embedded) { nmx = 0; nmy = 1; nmz = 0; corr = Math.max(corr, r * 0.35); }

        n.p = n.p.method_1031(nmx*corr, nmy*corr, nmz*corr);

        class_243 vel=n.p.method_1020(n.prev);
        double vdotn=vel.field_1352*nmx+vel.field_1351*nmy+vel.field_1350*nmz;
        if (vdotn<0.0) vel=vel.method_1023(nmx*vdotn,nmy*vdotn,nmz*vdotn);
        n.prev=n.p.method_1020(vel.method_1021(1.0-DYN_FRICTION));
    }

    private static double clamp(double v,double lo,double hi){
        return v < lo ? lo : (v > hi ? hi : v);
    }
}
