package net.kronoz.odyssey.systems.physics.wire;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_26;
import net.minecraft.class_3218;
import net.minecraft.class_7225;

public final class WireStorage extends class_18 {
    public static final String KEY = "odyssey_wires";

    private static final class_8645<WireStorage> TYPE = new class_8645<>(
            WireStorage::new,
            WireStorage::fromNbt,
            null
    );

    private final Map<UUID, WireRecord> records = new LinkedHashMap<>();

    public static WireStorage get(class_3218 world) {
        class_26 mgr = world.method_17983();
        return mgr.method_17924(TYPE, KEY);
    }

    public static WireStorage fromNbt(class_2487 nbt, class_7225.class_7874 lookup) {
        WireStorage storage = new WireStorage();
        class_2499 list = nbt.method_10554("wires", class_2487.field_33260);
        for (int i = 0; i < list.size(); i++) {
            WireRecord rec = WireRecord.fromNbt(list.method_10602(i));
            storage.records.put(rec.id, rec);
        }
        return storage;
    }

    @Override
    public class_2487 method_75(class_2487 nbt, class_7225.class_7874 lookup) {
        class_2499 list = new class_2499();
        for (WireRecord rec : records.values()) list.add(rec.toNbt());
        nbt.method_10566("wires", list);
        return nbt;
    }

    public void put(WireRecord rec) {
        records.put(rec.id, rec);
        method_80();
    }

    public void remove(UUID id) {
        if (records.remove(id) != null) method_80();
    }

    public WireRecord get(UUID id) { return records.get(id); }

    public Collection<WireRecord> all() { return records.values(); }
}