package net.kronoz.odyssey.systems.physics.wire;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;

public final class WireToolState {
    private WireToolState(){}

    private static final List<Entry> WIRES = new ArrayList<>();
    private static final WireDef DEF = WireDef.defaultCable(class_2960.method_60655("odyssey","textures/effects/wire.png"));

    public static Entry.Pending pending = null;

    public static void setPending(class_2338 pos, class_2350 face, class_2248 block){
        pending = new Entry.Pending(pos.method_10062(), face, block);
    }
    public static boolean hasPending(){ return pending != null; }
    public static void clearPending(){ pending = null; }

    public static void spawnWire(class_2338 aPos, class_2350 aFace, class_2248 aBlock,
                                 class_2338 bPos, class_2350 bFace, class_2248 bBlock){
        WIRES.add(new Entry(
                Anchor.blockFace(aPos, aFace, aBlock),
                Anchor.blockFace(bPos, bFace, bBlock)
        ));
    }

    public static void renderAll(class_4587 ms, class_4597 buffers, int light){
        var mc = class_310.method_1551();
        if (mc==null || mc.field_1687==null) return;

        final double REMOVE_AFTER_SECONDS = 6.0;
        final long now = System.currentTimeMillis();
        Iterator<Entry> it = WIRES.iterator();

        while (it.hasNext()){
            Entry e = it.next();

            boolean aAlive = e.a.isStillSameBlock(mc.field_1687);
            boolean bAlive = e.b.isStillSameBlock(mc.field_1687);

            class_243 a = e.a.world();
            class_243 b = e.b.world();

            WireManager.ensure(e.id, DEF, a, b);
            WireSim sim = WireManager.get(e.id);
            if (sim != null) sim.setPinned(aAlive, bAlive);

            WireManager.stepAndRender(e.id, a, aAlive, b, bAlive, ms, buffers, light, class_4608.field_21444);

            if (!aAlive || !bAlive){
                if (e.detachedAt == 0L) e.detachedAt = now;
                if (!aAlive && !bAlive && (now - e.detachedAt) > (long)(REMOVE_AFTER_SECONDS*1000)){
                    it.remove();
                }
            } else {
                e.detachedAt = 0L;
            }
        }
    }

    public static final class Entry {
        public final UUID id = UUID.randomUUID();
        public final Anchor a, b;
        public long detachedAt = 0L;
        public Entry(Anchor a, Anchor b){ this.a=a; this.b=b; }

        public static final class Pending {
            public final class_2338 pos;
            public final class_2350 face;
            public final class_2248 block;
            public Pending(class_2338 pos, class_2350 face, class_2248 block){ this.pos=pos; this.face=face; this.block=block; }
        }
    }

    public static final class Anchor {
        enum Kind { FREE, BLOCK_FACE }
        final Kind kind;
        final class_243 point;
        final class_2338 pos;
        final class_2350 face;
        final class_2248 originalBlock;

        private Anchor(class_243 p){ kind=Kind.FREE; point=p; pos=null; face=null; originalBlock=null; }
        private Anchor(class_2338 pos, class_2350 face, class_2248 block){ kind=Kind.BLOCK_FACE; this.pos=pos; this.face=face; this.originalBlock=block; point=null; }

        public static Anchor free(class_243 p){ return new Anchor(p); }
        public static Anchor blockFace(class_2338 pos, class_2350 face, class_2248 block){ return new Anchor(pos,face,block); }

        public boolean isStillSameBlock(net.minecraft.class_1937 world){
            if (kind==Kind.FREE) return true;
            return world.method_8320(pos).method_26204() == originalBlock;
        }

        public class_243 world(){
            if (kind==Kind.FREE) return point;
            return class_243.method_24953(pos).method_1031(
                    face.method_10148()*0.501,
                    face.method_10164()*0.501,
                    face.method_10165()*0.501
            );
        }
    }
}
