package net.kronoz.odyssey.systems.shaders;

import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import foundry.veil.platform.VeilEventPlatform;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_642;

public final class FogUniforms {
    private static final class_2960 FOG_PROGRAM = class_2960.method_60655("pinwheel", "fog/fog");

    private static String lastAddr = "";
    private static float seedX = 0.5f, seedY = 0.5f, seedZ = 0.5f;

    public static void init() {
        VeilEventPlatform.INSTANCE.preVeilPostProcessing((name, pipeline, ctx) -> {
            ShaderProgram fog = VeilRenderSystem.renderer()
                    .getPostProcessingManager()
                    .getPostPipelineContext().getShader(FOG_PROGRAM);
            if (fog == null) return;

            class_310 mc = class_310.method_1551();
            String addr = currentAddress(mc);
            if (!addr.equals(lastAddr)) {
                lastAddr = addr;
                // 3 independent seeds from the address string
                seedX = hashUnit(addr, 0x9E3779B9);
                seedY = hashUnit(addr, 0x7F4A7C15);
                seedZ = hashUnit(addr, 0x94D049BB);
            }

            fog.getOrCreateUniform("IPSeed").setVector(seedX, seedY, seedZ);
            fog.getOrCreateUniform("IPStrength").setFloat(0.6f);
        });
    }
    private static String currentAddress(class_310 mc) {
        if (mc.method_1542()) return "singleplayer";
        class_642 info = mc.method_1558();
        return info != null && info.field_3761 != null ? info.field_3761 : "unknown";
    }

    private static float hashUnit(String s, int salt) {
        int h = salt;
        for (int i = 0, n = s.length(); i < n; i++) {
            h ^= s.charAt(i);
            h *= 0x27d4eb2d;
        }
        return (h >>> 1) / (float)(Integer.MAX_VALUE);
    }

    private FogUniforms() {}
}
