package net.kronoz.odyssey.world;

import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public final class FixedStructureCenterSpawn {
    private FixedStructureCenterSpawn() {}

    public static void init() {
        ServerLifecycleEvents.SERVER_STARTED.register(FixedStructureCenterSpawn::applyWorldSpawnIfSaved);

        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 p = handler.field_14140;
            teleportToSavedCenter(server, p, true);
        });

        ServerPlayerEvents.AFTER_RESPAWN.register((oldP, newP, alive) -> {
            MinecraftServer server = newP.method_5682();
            if (server != null) teleportToSavedCenter(server, newP, true);
        });
    }

    private static void applyWorldSpawnIfSaved(MinecraftServer server) {
        class_3218 overworld = server.method_3847(class_1937.field_25179);
        if (overworld == null) return;

        var psm = overworld.method_17983();
        var state = psm.method_17924(FixedStructurePlacerOverworld.StructuresPlacedState.TYPE,
                                    FixedStructurePlacerOverworld.StructuresPlacedState.KEY);
        if (state.hasSpawn()) {
            overworld.method_8554(new class_2338(state.spawnX, state.spawnY, state.spawnZ), 0.0f);
        }
    }

    private static void teleportToSavedCenter(MinecraftServer server, class_3222 player, boolean giveLevitation) {
        class_3218 overworld = server.method_3847(class_1937.field_25179);
        if (overworld == null) return;

        var psm = overworld.method_17983();
        var state = psm.method_17924(FixedStructurePlacerOverworld.StructuresPlacedState.TYPE,
                                    FixedStructurePlacerOverworld.StructuresPlacedState.KEY);
        if (!state.hasSpawn()) return;

        double x = state.spawnX + 0.5;
        double y = state.spawnY + 0.1;
        double z = state.spawnZ + 0.5;

        player.field_6017 = 0.0f;
        player.method_14251(overworld, x, y, z, player.method_36454(), player.method_36455());

        if (giveLevitation) {
            // 2.5s levitation (50 ticks*? nah, 2.5s=50 ticks? correction: 20 ticks per second -> 2.5s = 50 ticks)
            player.method_6092(new class_1293(class_1294.field_5902, 50, 0, false, false));
        }
    }
}
