package net.kronoz.odyssey.world;

import com.mojang.logging.LogUtils;
import org.slf4j.Logger;

import java.io.DataInputStream;
import java.io.InputStream;
import java.util.*;
import java.util.zip.GZIPInputStream;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2806;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3545;
import net.minecraft.class_7923;

final class HugeNbtPlacer {
    private static final Logger LOGGER = LogUtils.getLogger();
    private HugeNbtPlacer() {}

    static final class Plan {
        final class_2382 size;
        final Map<class_1923, List<class_3545<class_2338, class_2680>>> byChunk = new HashMap<>();
        Plan(class_2382 size){ this.size = size; }
    }

    static Optional<class_2487> loadNbt(class_3218 world, class_2960 idBare) {
        var rm = world.method_8503().method_34864();

        // dump once (on first call) to show all .nbt files under odyssey/(structure|structures)
        dumpOnce(rm);

        var candidates = List.of(
                class_2960.method_60655(idBare.method_12836(), "structure/"  + idBare.method_12832() + ".nbt"),
                class_2960.method_60655(idBare.method_12836(), "structures/" + idBare.method_12832() + ".nbt"),
                class_2960.method_60655(idBare.method_12836(), "structure/"  + idBare.method_12832()),
                class_2960.method_60655(idBare.method_12836(), "structures/" + idBare.method_12832())
        );

        for (var path : candidates) {
            try {
                var opt = rm.method_14486(path);
                LogUtils.getLogger().info("[Odyssey] probe {} present={}", path, opt.isPresent());
                if (opt.isEmpty()) continue;

                // Fabric/Yarn 1.21.1: NbtIo.read(Path) — copy to temp, then read
                var tmp = java.nio.file.Files.createTempFile("odyssey_tmp_", ".nbt");
                try (var in = opt.get().method_14482()) {
                    java.nio.file.Files.copy(in, tmp, java.nio.file.StandardCopyOption.REPLACE_EXISTING);
                }
                var nbt = net.minecraft.class_2507.method_10633(tmp);
                java.nio.file.Files.deleteIfExists(tmp);
                return Optional.of(nbt);
            } catch (Exception e) {
                LogUtils.getLogger().warn("[Odyssey] read fail {}: {}", path, e.toString());
            }
        }
        return Optional.empty();
    }

    private static boolean DUMPED = false;
    private static void dumpOnce(net.minecraft.class_3300 rm) {
        if (DUMPED) return;
        DUMPED = true;
        try {
            var found = rm.method_14488("structure", id -> id.method_12832().endsWith(".nbt"));
            var found2 = rm.method_14488("structures", id -> id.method_12832().endsWith(".nbt"));
            LogUtils.getLogger().info("[Odyssey] namespaces={}", rm.method_14487());
            LogUtils.getLogger().info("[Odyssey] list data/odyssey/structure/*.nbt -> {}", found.keySet());
            LogUtils.getLogger().info("[Odyssey] list data/odyssey/structures/*.nbt -> {}", found2.keySet());
        } catch (Exception e) {
            LogUtils.getLogger().warn("[Odyssey] dumpOnce error: {}", e.toString());
        }
    }




    static Optional<Plan> planFromNbt(class_2487 nbt, class_2338 origin) {
        if (!nbt.method_10573("size", class_2520.field_33261)) return Optional.empty();
        int[] sz = nbt.method_10561("size");
        if (sz.length < 3) return Optional.empty();
        class_2382 size = new class_2382(sz[0], sz[1], sz[2]);

        if (!nbt.method_10573("palette", class_2520.field_33259)) return Optional.empty();
        class_2499 paletteList = nbt.method_10554("palette", class_2520.field_33260);
        List<class_2680> palette = new ArrayList<>(paletteList.size());
        for (int i = 0; i < paletteList.size(); i++) {
            class_2680 st = readState(paletteList.method_10602(i));
            if (st == null) st = class_2246.field_10124.method_9564();
            palette.add(st);
        }

        if (!nbt.method_10573("blocks", class_2520.field_33259)) return Optional.empty();
        class_2499 blocks = nbt.method_10554("blocks", class_2520.field_33260);
        Plan plan = new Plan(size);

        for (int i = 0; i < blocks.size(); i++) {
            class_2487 be = blocks.method_10602(i);
            int[] pos = be.method_10561("pos");
            if (pos.length < 3) continue;
            int idx = be.method_10550("state");
            class_2680 st = (idx >= 0 && idx < palette.size()) ? palette.get(idx) : class_2246.field_10124.method_9564();
            class_2338 wp = origin.method_10069(pos[0], pos[1], pos[2]);
            class_1923 c = new class_1923(wp);
            plan.byChunk.computeIfAbsent(c, k -> new ArrayList<>()).add(new class_3545<>(wp, st));
        }
        return Optional.of(plan);
    }

    private static class_2680 readState(class_2487 entry) {
        String name = entry.method_10558("Name");
        if (name == null || name.isEmpty()) return class_2246.field_10124.method_9564();
        class_2248 block = class_7923.field_41175.method_10223(class_2960.method_12829(name));
        class_2680 state = block.method_9564();
        if (entry.method_10573("Properties", class_2520.field_33260)) {
            class_2487 props = entry.method_10562("Properties");
            for (String key : props.method_10541()) {
                class_2769<?> prop = state.method_28501().stream().filter(p -> p.method_11899().equals(key)).findFirst().orElse(null);
                if (prop == null) continue;
                String val = props.method_10558(key);
                state = withParsed(state, prop, val);
            }
        }
        return state;
    }

    @SuppressWarnings({"unchecked","rawtypes"})
    private static <T extends Comparable<T>> class_2680 withParsed(class_2680 state, class_2769<T> prop, String val) {
        Optional<T> parsed = ((class_2769)prop).method_11900(val);
        return parsed.map(t -> state.method_11657(prop, t)).orElse(state);
    }

    static void forceChunks(class_3218 world, Plan plan) {
        for (class_1923 c : plan.byChunk.keySet()) {
            world.method_14178().method_12121(c.field_9181, c.field_9180, class_2806.field_12803, true);
        }
    }
}
